/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.HierarchyPermission;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.InvariantContainerConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantEditHelperAdvice;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantContainerEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInvariantEditHelperAdvice<InvariantContainerConfiguration> {
    protected List<HierarchyPermission> permissions;
    protected IClientContext sharedContext;

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof SetRequest) {
            EReference reference;
            SetRequest setRequest = (SetRequest)request;
            EStructuralFeature structuralFeature = setRequest.getFeature();
            if (structuralFeature instanceof EReference && (reference = (EReference)structuralFeature).isContainment() && setRequest.getValue() != null) {
                return this.canContain(setRequest);
            }
        } else if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType typeToCreate = createElementRequest.getElementType();
            boolean approvedRequest = this.isValid(typeToCreate, false);
            return approvedRequest;
        }
        return super.approveRequest(request);
    }

    protected boolean isValid(IElementType typeToAdd, boolean baseIsValid) {
        boolean isValid = baseIsValid;
        for (HierarchyPermission permission : this.permissions) {
            boolean isPermitted = permission.isIsPermitted();
            String childType = permission.getChildType();
            boolean isStrict = permission.isIsStrict();
            IElementType type = ElementTypeRegistry.getInstance().getType(childType);
            if (type == null) continue;
            if (isStrict) {
                if (typeToAdd.equals(type)) {
                    if (!isPermitted) continue;
                    isValid = true;
                    continue;
                }
                if (isPermitted) continue;
                isValid = false;
                continue;
            }
            List<IElementType> allTypes = Arrays.asList(typeToAdd.getAllSuperTypes());
            allTypes.add(typeToAdd);
            if (allTypes.contains(type)) {
                if (!isPermitted) continue;
                isValid = true;
                continue;
            }
            if (isPermitted) continue;
            isValid = false;
        }
        return isValid;
    }

    protected boolean canContain(SetRequest request) {
        if (request.getValue() instanceof List) {
            List values = (List)request.getValue();
            for (Object value : values) {
                if (!(value instanceof EObject)) continue;
                IElementType type = ElementTypeRegistry.getInstance().getElementType((EObject)value, request.getClientContext());
                if (type != null) {
                    if (this.isValid(type, false)) continue;
                    return false;
                }
                return false;
            }
        } else if (request.getValue() instanceof EObject) {
            IElementType type = ElementTypeRegistry.getInstance().getElementType((EObject)request.getValue(), request.getClientContext());
            if (type != null) {
                return this.isValid(type, false);
            }
            return false;
        }
        return true;
    }

    @Override
    public void init(InvariantContainerConfiguration configuration) {
        try {
            this.sharedContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        this.permissions = configuration.getPermissions();
    }
}

