/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.HierarchyPermission;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.InvariantContainerConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantElementMatcher;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantContainerMatcher
implements IInvariantElementMatcher<InvariantContainerConfiguration> {
    protected List<HierarchyPermission> permissions;
    protected IClientContext sharedContext;

    public boolean matches(EObject eObject) {
        EObject container = eObject.eContainer();
        if (container == null) {
            return false;
        }
        IElementType objectMetamodelType = ElementTypeRegistry.getInstance().getElementType(container, this.sharedContext);
        boolean isValid = false;
        for (HierarchyPermission permission : this.permissions) {
            boolean matchesSpecialization;
            IElementMatcher matcher;
            boolean isPermitted = permission.isIsPermitted();
            String childType = permission.getChildType();
            boolean isStrict = permission.isIsStrict();
            IElementType type = ElementTypeRegistry.getInstance().getType(childType);
            if (type instanceof IMetamodelType) {
                if (isStrict) {
                    isValid = type.equals(objectMetamodelType) ? isPermitted : !isPermitted;
                    continue;
                }
                isValid = Arrays.asList(objectMetamodelType.getAllSuperTypes()).contains(type) ? isPermitted : !isPermitted;
                continue;
            }
            if (!(type instanceof ISpecializationType) || (matcher = ((ISpecializationType)type).getMatcher()) == null) continue;
            boolean bl = matchesSpecialization = matcher.matches(container) && objectMetamodelType.equals(((ISpecializationType)type).getMetamodelType());
            if (matchesSpecialization) {
                if (isStrict) {
                    ISpecializationType[] subtypes = ElementTypeRegistry.getInstance().getSpecializationsOf(childType);
                    if (subtypes != null && subtypes.length > 0) {
                        ISpecializationType[] iSpecializationTypeArray = subtypes;
                        int n = subtypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ISpecializationType subType = iSpecializationTypeArray[n2];
                            isValid = subType.getMatcher().matches(container) ? isPermitted : !isPermitted;
                            ++n2;
                        }
                        continue;
                    }
                    isValid = isPermitted;
                    continue;
                }
                isValid = isPermitted;
                continue;
            }
            boolean bl2 = isValid = !isPermitted;
        }
        return isValid;
    }

    @Override
    public void init(InvariantContainerConfiguration configuration) {
        try {
            this.sharedContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        this.permissions = configuration.getPermissions();
    }
}

