/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.canonical.strategy;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.papyrus.infra.gmfdiag.canonical.internal.Activator;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.CreationTargetStrategyRegistration;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.DefaultSemanticChildrenStrategyRegistration;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.EditPartBasedRegistration;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ICreationTargetStrategy;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ISemanticChildrenStrategy;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.IVisualChildrenStrategy;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.Registration;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.SemanticChildrenStrategyRegistration;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.VisualChildrenStrategyRegistration;

public class SemanticChildrenStrategyRegistry {
    private final List<SemanticChildrenStrategyRegistration> strategies;
    private final Multimap<Class<?>, SemanticChildrenStrategyRegistration> strategiesByEditPart = ArrayListMultimap.create();
    private final List<DefaultSemanticChildrenStrategyRegistration> defaultStrategies;
    private final List<VisualChildrenStrategyRegistration> visualChildrenStrategies;
    private final Multimap<Class<?>, VisualChildrenStrategyRegistration> visualChildrenStrategiesByEditPart = ArrayListMultimap.create();
    private final List<CreationTargetStrategyRegistration> creationTargetStrategies;
    private static SemanticChildrenStrategyRegistry INSTANCE = new SemanticChildrenStrategyRegistry();

    public static SemanticChildrenStrategyRegistry getInstance() {
        return INSTANCE;
    }

    private SemanticChildrenStrategyRegistry() {
        ArrayList strategies = Lists.newArrayList();
        ArrayList defaultStrategies = Lists.newArrayListWithExpectedSize((int)1);
        ArrayList creationTargetStrategies = Lists.newArrayList();
        ArrayList visualChildrenStrategies = Lists.newArrayList();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.gmfdiag.canonical.strategies");
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement config = configElements[i];
            try {
                switch (config.getName()) {
                    case "semanticChildrenStrategy": {
                        strategies.add(new SemanticChildrenStrategyRegistration(config));
                        break;
                    }
                    case "defaultSemanticChildrenStrategy": {
                        defaultStrategies.add(new DefaultSemanticChildrenStrategyRegistration(config));
                        break;
                    }
                    case "creationTargetStrategy": {
                        creationTargetStrategies.add(new CreationTargetStrategyRegistration(config));
                        break;
                    }
                    case "visualChildrenStrategy": {
                        visualChildrenStrategies.add(new VisualChildrenStrategyRegistration(config));
                        break;
                    }
                    default: {
                        Activator.log.warn(String.format("Unrecognized configuration element <%s> from plug-in %s", config.getName(), config.getContributor().getName()));
                        break;
                    }
                }
            }
            catch (Exception e) {
                Activator.log.error("Error loading extension from plug-in " + config.getContributor().getName(), (Throwable)e);
            }
            ++i;
        }
        this.strategies = Ordering.natural().reverse().immutableSortedCopy((Iterable)strategies);
        this.defaultStrategies = Ordering.natural().reverse().immutableSortedCopy((Iterable)defaultStrategies);
        this.creationTargetStrategies = Ordering.natural().reverse().immutableSortedCopy((Iterable)creationTargetStrategies);
        this.visualChildrenStrategies = Ordering.natural().reverse().immutableSortedCopy((Iterable)visualChildrenStrategies);
    }

    public ISemanticChildrenStrategy getSemanticChildrenStrategy(EditPart editPart) {
        ISemanticChildrenStrategy result = (ISemanticChildrenStrategy)SemanticChildrenStrategyRegistry.getStrategy(editPart, this.strategiesByEditPart, this.strategies);
        if (result == null) {
            for (DefaultSemanticChildrenStrategyRegistration next : this.defaultStrategies) {
                if (!next.isApplicableTo(editPart) || next.getExtension() == null) continue;
                result = (ISemanticChildrenStrategy)next.getExtension();
                break;
            }
        }
        return result;
    }

    private static <T, R extends EditPartBasedRegistration<T, R>> T getStrategy(EditPart editPart, Multimap<Class<?>, R> byEditPart, List<R> registrations) {
        Class<?> key = editPart.getClass();
        Registration reg = null;
        if (!byEditPart.containsKey(key)) {
            for (EditPartBasedRegistration next : registrations) {
                if (!next.matchesEditPartType(key)) continue;
                byEditPart.put(key, (Object)next);
                if (reg != null || !next.isApplicableTo(editPart) || next.getExtension() == null) continue;
                reg = next;
            }
        } else {
            for (EditPartBasedRegistration next : byEditPart.get(key)) {
                if (!next.isApplicableTo(editPart) || next.getExtension() == null) continue;
                reg = next;
                break;
            }
        }
        return reg == null ? null : (T)reg.getExtension();
    }

    private static <T, R extends Registration<T, R>> T getStrategy(EditPart editPart, List<R> registrations) {
        Registration reg = null;
        for (Registration next : registrations) {
            if (!next.isApplicableTo(editPart)) continue;
            reg = next;
            break;
        }
        return reg == null ? null : (T)reg.getExtension();
    }

    public ICreationTargetStrategy getCreationTargetStrategy(EditPart editPart) {
        return (ICreationTargetStrategy)SemanticChildrenStrategyRegistry.getStrategy(editPart, this.creationTargetStrategies);
    }

    public IVisualChildrenStrategy getVisualChildrenStrategy(EditPart editPart) {
        return (IVisualChildrenStrategy)SemanticChildrenStrategyRegistry.getStrategy(editPart, this.visualChildrenStrategiesByEditPart, this.visualChildrenStrategies);
    }
}

