/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpart;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.ResizableLabelLocator;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomIntStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.BorderDisplayEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.LabelAlignmentEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.LabelPrimarySelectionEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.RefreshTextAlignmentEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.IPapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.locator.IPapyrusBorderItemLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.locator.PapyrusLabelLocator;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.NamedStyleProperties;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PositionEnum;

public abstract class PapyrusLabelEditPart
extends LabelEditPart
implements NamedStyleProperties {
    public static final int DEFAULT_MARGIN = 0;
    protected PapyrusLabelLocator papyrusLabelLocator = null;
    protected IPapyrusBorderItemLocator borderLabelLocator = null;
    private IObservableValue labelConstrainedObservable;
    private IChangeListener namedStyleListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            PapyrusLabelEditPart.this.refresh();
        }
    };
    private IObservableValue positionObservable;
    private IObservableValue labelOffsetXObservable;
    private IObservableValue labelOffsetYObservable;
    private IObservableValue leftMarginObservable;
    private IObservableValue rightMarginObservable;
    private IObservableValue topMarginObservable;
    private IObservableValue bottomMarginObservable;

    public PapyrusLabelEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("BORDER_DISPLAY_EDITPOLICY", (EditPolicy)new BorderDisplayEditPolicy());
        this.installEditPolicy("Label Alignment", (EditPolicy)new LabelAlignmentEditPolicy());
        this.installEditPolicy("primary_label", (EditPolicy)new LabelPrimarySelectionEditPolicy());
        this.installEditPolicy("Refresh text alignment edit policy", (EditPolicy)new RefreshTextAlignmentEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabelMargin();
    }

    public void refreshBounds() {
        if (this.isResizable()) {
            this.handleResizableRefreshBounds();
        } else {
            this.handleNonResizableRefreshBoundS();
        }
    }

    private void handleNonResizableRefreshBoundS() {
        int dx = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int dy = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point offset = new Point(dx, dy);
        if (this.getParent() instanceof AbstractConnectionEditPart) {
            AbstractGraphicalEditPart parentEditPart = (AbstractGraphicalEditPart)this.getParent();
            Connection connectionFigure = ((AbstractConnectionEditPart)this.getParent()).getConnectionFigure();
            if (this.papyrusLabelLocator != null) {
                this.papyrusLabelLocator.setOffset(offset);
            } else {
                this.papyrusLabelLocator = new PapyrusLabelLocator((IFigure)connectionFigure, offset, this.getKeyPoint());
            }
            this.papyrusLabelLocator.setTextAlignment(this.getTextAlignment());
            this.papyrusLabelLocator.setView((View)this.getModel());
            parentEditPart.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)this.papyrusLabelLocator);
        } else {
            this.setExternalLabelLocator(offset);
            this.getFigure().getParent().setConstraint(this.getFigure(), (Object)this.borderLabelLocator);
        }
    }

    public PapyrusLabelLocator getPapyrusLabelLocator() {
        return this.papyrusLabelLocator;
    }

    private void setExternalLabelLocator(Point offset) {
        if (this.borderLabelLocator == null) {
            this.borderLabelLocator = (IPapyrusBorderItemLocator)this.getBorderItemLocator();
        }
        if (offset != null) {
            this.borderLabelLocator.setConstraint(new Rectangle(offset.x, offset.y, 0, 0));
        }
        this.borderLabelLocator.setView((View)this.getModel());
        this.borderLabelLocator.setEditpart((EditPart)this);
        this.borderLabelLocator.setTextAlignment(this.getTextAlignment());
    }

    public Object getBorderItemLocator() {
        IFigure parentFigure = this.getFigure().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint(this.getFigure());
            return constraint;
        }
        return null;
    }

    public int getTextAlignment() {
        View model = (View)this.getModel();
        StringValueStyle labelAlignment = (StringValueStyle)model.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), "textAlignment");
        int textAlignment = 0;
        if (labelAlignment != null) {
            if (PositionEnum.LEFT.toString().equals(labelAlignment.getStringValue())) {
                textAlignment = 1;
            }
            if (PositionEnum.RIGHT.toString().equals(labelAlignment.getStringValue())) {
                textAlignment = 4;
            }
            if (PositionEnum.CENTER.toString().equals(labelAlignment.getStringValue())) {
                textAlignment = 2;
            }
        } else {
            textAlignment = this.getDefaultTextAlignment();
        }
        return textAlignment;
    }

    private void handleResizableRefreshBounds() {
        int dx = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int dy = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Rectangle rectangle = new Rectangle(dx, dy, width, height);
        if (this.getParent() instanceof AbstractConnectionEditPart) {
            ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new ResizableLabelLocator((IFigure)((AbstractConnectionEditPart)this.getParent()).getConnectionFigure(), rectangle, this.getKeyPoint()));
        } else {
            this.getFigure().getParent().setConstraint(this.getFigure(), (Object)new ResizableLabelLocator(this.getFigure().getParent(), rectangle, this.getKeyPoint()));
        }
    }

    private boolean isResizable() {
        EditPolicy editPolicy = this.getEditPolicy("PrimaryDrag Policy");
        return editPolicy instanceof ResizableEditPolicy;
    }

    public void refresh() {
        super.refresh();
        if (this.getBorderItemLocator() instanceof IPapyrusBorderItemLocator) {
            this.setExternalLabelLocator(null);
            this.refreshLabelConstrained();
            this.refreshLabelOffset();
        }
    }

    private void refreshLabelOffset() {
        Object model = this.getModel();
        if (model instanceof View) {
            int labelOffsetX = NotationUtils.getIntValue((View)this.getModel(), "labelOffsetX", this.getDefaultLabelOffsetX());
            int labelOffsetY = NotationUtils.getIntValue((View)this.getModel(), "labelOffsetY", this.getDefaultLabelOffsetY());
            ((IPapyrusBorderItemLocator)this.getBorderItemLocator()).setOffset(new Dimension(labelOffsetX, labelOffsetY));
        }
    }

    private void refreshLabelConstrained() {
        Object model = this.getModel();
        if (model instanceof View) {
            ((IPapyrusBorderItemLocator)this.getBorderItemLocator()).setConstrained(this.isLabelConstrained());
        }
    }

    public boolean isLabelConstrained() {
        boolean labelConstrained = NotationUtils.getBooleanValue((View)this.getModel(), "labelConstrained", this.getDefaultLabelConstrained());
        return labelConstrained;
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        View view = (View)this.getModel();
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)view);
        this.labelConstrainedObservable = new CustomBooleanStyleObservableValue(view, domain, "labelConstrained");
        this.labelConstrainedObservable.addChangeListener(this.namedStyleListener);
        this.positionObservable = new CustomStringStyleObservableValue(view, domain, "position");
        this.positionObservable.addChangeListener(this.namedStyleListener);
        this.labelOffsetXObservable = new CustomIntStyleObservableValue(view, domain, "labelOffsetX");
        this.labelOffsetXObservable.addChangeListener(this.namedStyleListener);
        this.labelOffsetYObservable = new CustomIntStyleObservableValue(view, domain, "labelOffsetY");
        this.labelOffsetYObservable.addChangeListener(this.namedStyleListener);
        this.leftMarginObservable = new CustomIntStyleObservableValue(view, domain, "leftMarginLabel");
        this.leftMarginObservable.addChangeListener(this.namedStyleListener);
        this.rightMarginObservable = new CustomIntStyleObservableValue(view, domain, "rightMarginLabel");
        this.rightMarginObservable.addChangeListener(this.namedStyleListener);
        this.topMarginObservable = new CustomIntStyleObservableValue(view, domain, "topMarginLabel");
        this.topMarginObservable.addChangeListener(this.namedStyleListener);
        this.bottomMarginObservable = new CustomIntStyleObservableValue(view, domain, "bottomMarginLabel");
        this.bottomMarginObservable.addChangeListener(this.namedStyleListener);
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.labelConstrainedObservable.dispose();
        this.positionObservable.dispose();
        this.labelOffsetXObservable.dispose();
        this.labelOffsetYObservable.dispose();
        this.leftMarginObservable.dispose();
        this.rightMarginObservable.dispose();
        this.topMarginObservable.dispose();
        this.bottomMarginObservable.dispose();
    }

    protected int getDefaultLabelOffsetY() {
        return 0;
    }

    protected int getDefaultLabelOffsetX() {
        return 0;
    }

    protected boolean getDefaultLabelConstrained() {
        return false;
    }

    protected int getDefaultTextAlignment() {
        EditPart parent = this.getParent();
        if (parent instanceof NodeEditPart || parent instanceof AbstractBorderItemEditPart) {
            return 1;
        }
        if (parent instanceof ConnectionEditPart) {
            return 2;
        }
        return 2;
    }

    public void refreshLabelMargin() {
        IFigure figure = null;
        int leftMargin = 0;
        int rightMargin = 0;
        int topMargin = 0;
        int bottomMargin = 0;
        Object model = this.getModel();
        if (model instanceof View) {
            leftMargin = NotationUtils.getIntValue((View)model, "leftMarginLabel", 0);
            rightMargin = NotationUtils.getIntValue((View)model, "rightMarginLabel", 0);
            topMargin = NotationUtils.getIntValue((View)model, "topMarginLabel", 0);
            bottomMargin = NotationUtils.getIntValue((View)model, "bottomMarginLabel", 0);
        }
        if ((figure = this.getFigure()) instanceof IPapyrusWrappingLabel) {
            ((IPapyrusWrappingLabel)figure).setMarginLabel(leftMargin, topMargin, rightMargin, bottomMargin);
            if (this.borderLabelLocator != null) {
                this.borderLabelLocator.setMargin(new Point(leftMargin + rightMargin, topMargin + bottomMargin));
            } else if (this.papyrusLabelLocator != null) {
                this.papyrusLabelLocator.setMargin(new Point(leftMargin + rightMargin, topMargin + bottomMargin));
            }
        }
    }

    public Object getAdapter(Class key) {
        if (IResource.class == key && this.getParent() == null) {
            return null;
        }
        return super.getAdapter(key);
    }
}

