/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.OneTopLineResizableBorder;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.NamedStyleProperties;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PositionEnum;

public class BorderDisplayEditPolicy
extends GraphicalEditPolicyEx
implements IChangeListener,
NotificationListener,
NamedStyleProperties {
    private static final String LINE_POSITION_DEFAULT_VALUE = PositionEnum.CENTER.toString();
    private static final String LINE_LENGTH_RATIO_DEFAULT_VALUE = "1.0";
    private static final int DEFAULT_LENGTH_VALUE = -1;
    public static final String BORDER_DISPLAY_EDITPOLICY = "BORDER_DISPLAY_EDITPOLICY";
    protected IObservableValue styleObservable;
    protected Border defaultBorder;

    public void activate() {
        View view = (View)this.getHost().getModel();
        if (view == null) {
            return;
        }
        this.styleObservable = new CustomBooleanStyleObservableValue(view, EMFHelper.resolveEditingDomain((EObject)view), "displayBorder");
        this.styleObservable.addChangeListener((IChangeListener)this);
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
        EObject semanticElement = EMFHelper.getEObject((Object)this.getHost());
        if (semanticElement != null) {
            this.getDiagramEventBroker().addNotificationListener(semanticElement, (NotificationListener)this);
        }
        this.refreshBorderDisplay();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void deactivate() {
        if (this.styleObservable != null) {
            this.styleObservable.removeChangeListener((IChangeListener)this);
            this.styleObservable.dispose();
            this.styleObservable = null;
        }
    }

    public void notifyChanged(Notification notification) {
        this.refreshBorderDisplay();
    }

    public void handleChange(ChangeEvent event) {
        this.getHost().refresh();
    }

    public void refresh() {
        this.refreshBorderDisplay();
    }

    protected IFigure getPrimaryShape() {
        EditPart host = this.getHost();
        if (host instanceof IPapyrusEditPart) {
            IPapyrusEditPart graphicalHost = (IPapyrusEditPart)host;
            return graphicalHost.getPrimaryShape();
        }
        return this.getHostFigure();
    }

    protected View getNotationView() {
        EditPart host = this.getHost();
        if (host instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)host).getNotationView();
        }
        View view = (View)host.getAdapter(View.class);
        return view;
    }

    protected void refreshBorderDisplay() {
        View view = this.getNotationView();
        if (view == null) {
            return;
        }
        BooleanValueStyle displayBorderStyle = this.findDisplayBorderStyle(view);
        if (displayBorderStyle != null && !displayBorderStyle.isBooleanValue()) {
            if (this.defaultBorder == null) {
                this.defaultBorder = this.getPrimaryShape().getBorder();
            }
            this.getPrimaryShape().setBorder(null);
        } else if (this.getPrimaryShape() instanceof ResizableCompartmentFigure) {
            if (!(this.defaultBorder instanceof OneTopLineResizableBorder)) {
                this.defaultBorder = new OneTopLineResizableBorder(2);
            }
            this.getPrimaryShape().setBorder(this.defaultBorder);
            ((OneTopLineResizableBorder)this.defaultBorder).setLength(NotationUtils.getIntValue(view, "lineLength", -1));
            ((OneTopLineResizableBorder)this.defaultBorder).setLengthRatio(new Float(NotationUtils.getStringValue(view, "lineLengthRatio", LINE_LENGTH_RATIO_DEFAULT_VALUE)).floatValue());
            ((OneTopLineResizableBorder)this.defaultBorder).setLinePosition(this.getlinePosition());
            List<View> allVisibleCompartments = BorderDisplayEditPolicy.getAllVisibleCompartments(view, this.getHost().getParent());
            if (allVisibleCompartments.size() > 0 && allVisibleCompartments.get(0).equals(view)) {
                this.getPrimaryShape().setBorder(null);
            }
        } else if (this.defaultBorder != null) {
            this.getPrimaryShape().setBorder(this.defaultBorder);
        }
    }

    public int getlinePosition() {
        View view = this.getNotationView();
        String linePosition = NotationUtils.getStringValue(view, "linePosition", LINE_POSITION_DEFAULT_VALUE);
        int position = 2;
        if (PositionEnum.LEFT.toString().equals(linePosition)) {
            position = 1;
        }
        if (PositionEnum.RIGHT.toString().equals(linePosition)) {
            position = 4;
        }
        if (PositionEnum.CENTER.toString().equals(linePosition)) {
            position = 2;
        }
        return position;
    }

    public static List<View> getAllVisibleCompartments(View view, EditPart editpart) {
        ArrayList<View> visibleCompartments = new ArrayList<View>();
        if (editpart == null) {
            return visibleCompartments;
        }
        List localChildren = editpart.getChildren();
        for (Object current : localChildren) {
            boolean isNameDiplayed;
            if (!(current instanceof CompartmentEditPart)) continue;
            BooleanValueStyle displayNameStyle = (BooleanValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "displayName");
            boolean bl = isNameDiplayed = displayNameStyle != null ? displayNameStyle.isBooleanValue() : true;
            if (current instanceof ITextAwareEditPart) {
                if (!isNameDiplayed) continue;
                visibleCompartments.add((View)((CompartmentEditPart)current).getModel());
                continue;
            }
            visibleCompartments.add((View)((CompartmentEditPart)current).getModel());
        }
        return visibleCompartments;
    }

    private BooleanValueStyle findDisplayBorderStyle(View view) {
        View parentView = view;
        while (parentView.getElement() == view.getElement()) {
            BooleanValueStyle style = (BooleanValueStyle)parentView.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), "displayBorder");
            if (style != null) {
                return style;
            }
            if (!(parentView.eContainer() instanceof View)) break;
            parentView = (View)parentView.eContainer();
        }
        return null;
    }
}

