/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.elementtypesconfigurations.registries.ElementTypeConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel.Representation;
import org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel.RepresentationKind;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class ExpansionModelValidationUtil {
    public static boolean validate_facrtories(AbstractRepresentation abstractRepresentation, DiagnosticChain diagnostic, Map context) {
        boolean valid = true;
        if (diagnostic != null && abstractRepresentation.getKind() == null && (abstractRepresentation.getEditPartQualifiedName() == null || "".equals(abstractRepresentation.getEditPartQualifiedName().trim())) && (abstractRepresentation.getViewFactory() == null || "".equals(abstractRepresentation.getViewFactory().trim()))) {
            valid = false;
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' has no kind , no editpartQualifiedName, no viewFactory.", new Object[]{abstractRepresentation}));
        }
        return valid;
    }

    public static boolean validate_loadclasses(AbstractRepresentation abstractRepresentation, DiagnosticChain diagnostic, Map context) {
        boolean valid = true;
        if (diagnostic != null) {
            Class loadedClass;
            if (abstractRepresentation.getEditPartQualifiedName() != null && !"".equals(abstractRepresentation.getEditPartQualifiedName().trim()) && (loadedClass = ClassLoaderHelper.loadClass((String)abstractRepresentation.getEditPartQualifiedName())) == null) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references an edit part that does not exist " + abstractRepresentation.getEditPartQualifiedName(), new Object[]{abstractRepresentation}));
            }
            if (abstractRepresentation.getViewFactory() != null && !"".equals(abstractRepresentation.getViewFactory().trim()) && (loadedClass = ClassLoaderHelper.loadClass((String)abstractRepresentation.getViewFactory())) == null) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references a view factory that not exist " + abstractRepresentation.getViewFactory(), new Object[]{abstractRepresentation}));
            }
        }
        return valid;
    }

    public static boolean validate_loadclasses(RepresentationKind abstractRepresentation, DiagnosticChain diagnostic, Map context) {
        boolean valid = true;
        if (diagnostic != null) {
            Class loadedClass;
            if (!(abstractRepresentation.getEditPartQualifiedName() == null && "".equals(abstractRepresentation.getEditPartQualifiedName().trim()) || (loadedClass = ClassLoaderHelper.loadClass((String)abstractRepresentation.getEditPartQualifiedName())) != null)) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references an edit part that does not exist " + abstractRepresentation.getEditPartQualifiedName(), new Object[]{abstractRepresentation}));
            }
            if (!(abstractRepresentation.getViewFactory() == null && "".equals(abstractRepresentation.getViewFactory().trim()) || (loadedClass = ClassLoaderHelper.loadClass((String)abstractRepresentation.getViewFactory())) != null)) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references a view factory that does not exist " + abstractRepresentation.getViewFactory(), new Object[]{abstractRepresentation}));
            }
        }
        return valid;
    }

    public static boolean validate_ElementType(Representation abstractRepresentation, DiagnosticChain diagnostic, Map context) {
        boolean valid = true;
        String elementTypeID = abstractRepresentation.getGraphicalElementType();
        if (elementTypeID != null && !elementTypeID.isEmpty()) {
            ElementTypeConfigurationTypeRegistry.getInstance();
            IElementType elementType = ElementTypeRegistry.getInstance().getType(elementTypeID);
            if (elementType == null) {
                valid = false;
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.common.expansionmodel", 1, "The representation '" + abstractRepresentation.getName() + "' references a element type that does not exist " + abstractRepresentation.getGraphicalElementType(), new Object[]{abstractRepresentation}));
            }
        }
        return valid;
    }
}

