/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;

public class SlidableRoundedRectangleAnchor
extends SlidableAnchor {
    private Dimension offset = new Dimension();

    public SlidableRoundedRectangleAnchor(IFigure figure) {
        super(figure);
    }

    public SlidableRoundedRectangleAnchor(IFigure figure, PrecisionPoint p) {
        super(figure, p);
    }

    protected Rectangle getBox() {
        PrecisionRectangle rBox = null;
        Object figure = this.getFigure();
        if (figure instanceof IRoundedRectangleFigure) {
            rBox = new PrecisionRectangle(((IRoundedRectangleFigure)((IFigure)figure)).getRoundedRectangleBounds());
        } else if (figure instanceof IFigure) {
            rBox = new PrecisionRectangle(this.getOwner().getBounds());
        }
        if (rBox != null) {
            ((IFigure)figure).translateToAbsolute((Translatable)rBox);
            return rBox.expand(this.offset.width, this.offset.height);
        }
        return null;
    }

    private Object getFigure() {
        Object result = null;
        if (this.getOwner().getChildren().size() > 0) {
            result = this.getOwner().getChildren().get(0);
        }
        return result;
    }

    public PointList getPolygonPoints() {
        if (this.getFigure() instanceof IRoundedRectangleFigure) {
            IRoundedRectangleFigure packageFigure = (IRoundedRectangleFigure)((IFigure)this.getFigure());
            Rectangle packageHeader = packageFigure.getPackageHeader().getCopy();
            packageFigure.translateToAbsolute((Translatable)packageHeader);
            if (!packageHeader.isEmpty()) {
                PointList points = new PointList(5);
                Rectangle anchorableRectangle = this.getBox();
                points.addPoint(anchorableRectangle.x, anchorableRectangle.y);
                points.addPoint(anchorableRectangle.x + packageHeader.width, anchorableRectangle.y);
                points.addPoint(anchorableRectangle.x + packageHeader.width, anchorableRectangle.y + packageHeader.height);
                points.addPoint(anchorableRectangle.x + anchorableRectangle.width, anchorableRectangle.y + packageHeader.height);
                points.addPoint(anchorableRectangle.x + anchorableRectangle.width, anchorableRectangle.y + anchorableRectangle.height);
                points.addPoint(anchorableRectangle.x, anchorableRectangle.y + anchorableRectangle.height);
                points.addPoint(anchorableRectangle.x, anchorableRectangle.y);
                return points;
            }
            return super.getPolygonPoints();
        }
        return super.getPolygonPoints();
    }

    protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
        PointList pointList = null;
        Object figure = this.getFigure();
        if (figure instanceof IRoundedRectangleFigure) {
            if (!((IRoundedRectangleFigure)figure).getPackageHeader().isEmpty()) {
                PointList polygon = this.getPolygonPoints();
                pointList = new LineSeg(ownReference, foreignReference).getLineIntersectionsWithLineSegs(polygon);
            } else {
                Rectangle rect = this.getBox();
                Dimension dimension = null;
                if (figure instanceof IRoundedRectangleFigure) {
                    ((IRoundedRectangleFigure)figure).setOval(((IRoundedRectangleFigure)figure).isOval());
                    dimension = ((IRoundedRectangleFigure)figure).getCornerDimensions().getCopy();
                } else {
                    dimension = new Dimension();
                }
                if (rect.height < dimension.height) {
                    dimension.height = rect.height;
                }
                if (rect.width < dimension.width) {
                    dimension.width = rect.width;
                }
                PrecisionRectangle corner = new PrecisionRectangle(new Rectangle(0, 0, dimension.width, dimension.height));
                ((IFigure)figure).translateToAbsolute((Translatable)corner);
                pointList = this.getLineIntersectionsWithRoundedRectangle(new LineSeg(ownReference, foreignReference), rect.x, rect.y, rect.width, rect.height, corner.width, corner.height);
            }
        } else {
            pointList = super.getIntersectionPoints(ownReference, foreignReference);
        }
        return pointList;
    }

    private PointList getLineIntersectionsWithRoundedRectangle(LineSeg line, int rectX, int rectY, int rectW, int rectH, int arcW, int arcH) {
        Point point;
        PointList intersections = new PointList();
        PointList rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX + arcW / 2, rectY));
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW - arcW / 2, rectY));
        PointList rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX + arcW / 2, rectY + rectH));
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW - arcW / 2, rectY + rectH));
        rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX, rectY + arcH / 2));
        rect.addPoint((Point)new PrecisionPoint(rectX, rectY + rectH - arcH / 2));
        rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        rect = new PointList();
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW, rectY + arcH / 2));
        rect.addPoint((Point)new PrecisionPoint(rectX + rectW, rectY + rectH - arcH / 2));
        rectIntersections = line.getLineIntersectionsWithLineSegs(rect);
        if (rectIntersections.size() > 0) {
            intersections.addPoint(rectIntersections.getFirstPoint());
        }
        PointList ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX, rectY, arcW, arcH));
        int i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x <= rectX + arcW / 2 && point.y <= rectY + arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX + rectW - arcW, rectY, arcW, arcH));
        i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x >= rectX + rectW - arcW / 2 && point.y <= rectY + arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX, rectY + rectH - arcH, arcW, arcH));
        i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x <= rectX + arcW / 2 && point.y >= rectY + rectH - arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        ellipseIntersections = line.getLineIntersectionsWithEllipse(new Rectangle(rectX + rectW - arcW, rectY + rectH - arcH, arcW, arcH));
        i = 0;
        while (i < ellipseIntersections.size()) {
            point = ellipseIntersections.getPoint(i);
            if (point.x >= rectX + rectW - arcW / 2 && point.y >= rectY + rectH - arcH / 2) {
                intersections.addPoint(point);
            }
            ++i;
        }
        if (intersections.size() == 2) {
            Point point1 = intersections.getLastPoint();
            Point point2 = intersections.getFirstPoint();
            int deltaX1 = point1.x - line.getTerminus().x;
            int deltaY1 = point1.y - line.getTerminus().y;
            int deltaX2 = point2.x - line.getTerminus().x;
            int deltaY2 = point2.y - line.getTerminus().y;
            if (deltaX1 * deltaX1 + deltaY1 * deltaY1 < deltaX2 * deltaX2 + deltaY2 * deltaY2) {
                intersections.removePoint(0);
            } else {
                intersections.removePoint(1);
            }
        }
        return intersections;
    }

    public Point getLocation(Point refParent, Point refPort) {
        return super.getLocation(refParent, refPort);
    }

    public void setOffset(Dimension portOffset) {
        this.offset.height = portOffset.height;
        this.offset.width = portOffset.width;
    }
}

