/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.utils;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.service.ILocalPageService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForSelection;
import org.eclipse.papyrus.infra.gmfdiag.export.engine.ExportDiagramLocalPageService;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;

public class SelectionHelper {
    private SelectionHelper() {
    }

    public static IFile convertSelection2File(ISelection selection) {
        IStructuredSelection structuredSelection;
        IFile foundFile = null;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty() && structuredSelection.size() == 1) {
            Object selectedObject = structuredSelection.getFirstElement();
            foundFile = SelectionHelper.getIFile(selectedObject);
        }
        return foundFile;
    }

    public static IFile getIFile(Object selectedObj) {
        Collection collec;
        IFile result = null;
        if (selectedObj instanceof IFile) {
            result = (IFile)selectedObj;
        }
        if (result == null && selectedObj instanceof IAdaptable) {
            result = (IFile)((IAdaptable)selectedObj).getAdapter(IFile.class);
        }
        if (result == null) {
            result = (IFile)Platform.getAdapterManager().getAdapter(selectedObj, IFile.class);
        }
        if (result == null && (collec = (Collection)Platform.getAdapterManager().getAdapter(selectedObj, Collection.class)) != null) {
            for (Object o : collec) {
                IFile f;
                if (!(o instanceof IFile) || !"di".equals((f = (IFile)o).getFileExtension())) continue;
                result = f;
                break;
            }
        }
        return result != null && "di".equals(result.getFileExtension()) ? result : null;
    }

    public static boolean isExportableModel(IStructuredSelection receiver) {
        IPageManager pageManager = null;
        try {
            pageManager = ServiceUtilsForSelection.getInstance().getIPageManager((Object)receiver);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        boolean isExportable = false;
        if (pageManager != null) {
            ModelSet modelSet = null;
            try {
                modelSet = ServiceUtilsForSelection.getInstance().getModelSet((Object)receiver);
            }
            catch (ServiceException e) {
                return false;
            }
            Resource umlResource = UmlUtils.getUmlResource((ModelSet)modelSet);
            ExportDiagramLocalPageService service = new ExportDiagramLocalPageService(umlResource.getContents().get(0));
            List localPages = pageManager.allLocalPages((ILocalPageService)service);
            isExportable = !localPages.isEmpty();
        }
        return isExportable;
    }
}

