/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.databinding;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.UnitsConverterUtils;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.IntegerDiagramViewObservableValue;

public class RulersUnitObservableValue
extends IntegerDiagramViewObservableValue {
    public RulersUnitObservableValue(Diagram view, IPreferenceStore store) {
        super(view, "rulergrid.rulerunit", store);
    }

    protected void doSetValue(Object value) {
        if (value instanceof Integer) {
            Integer oldValue = (Integer)this.doGetValue();
            IPreferenceStore wsPreferenceStore = this.getEditedPreferenceStore();
            Double oldGridSpacing = wsPreferenceStore.getDouble("rulergrid.gridspacing");
            String newValue = UnitsConverterUtils.convertUnits((int)oldValue, (int)((Integer)value), (String)NumberFormat.getInstance().format(oldGridSpacing));
            Number number = null;
            try {
                number = NumberFormat.getInstance().parse(newValue);
            }
            catch (ParseException e) {
                number = null;
                return;
            }
            super.doSetValue(value);
            double newGridSpacing = number.doubleValue();
            wsPreferenceStore.setValue("rulergrid.gridspacing", newGridSpacing);
        }
    }
}

