/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.modelresource;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class PapyrusNattableModel
extends AbstractModelWithSharedResource<Table>
implements IModel {
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.nattable.resource.NattableModel";
    public static final String TABLE_MODEL_FILE_EXTENSION = "notation";

    public void init(ModelSet modelManager) {
        super.init(modelManager);
    }

    protected String getModelFileExtension() {
        return TABLE_MODEL_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void addPapyrusTable(Table tableInstance) {
        EObject context = tableInstance.getContext();
        if (context != null) {
            Resource targetResource;
            Resource contextResource = context.eResource();
            if (!contextResource.getURI().trimFileExtension().equals(this.getResource().getURI().trimFileExtension())) {
                URI uri = contextResource.getURI();
                uri = uri.trimFileExtension();
                uri = uri.appendFileExtension(this.getModelFileExtension());
                ResourceSet set = contextResource.getResourceSet();
                targetResource = set.getResource(uri, true);
            } else {
                targetResource = this.getResource();
            }
            if (targetResource != null) {
                targetResource.getContents().add((Object)tableInstance);
            }
        }
    }

    public void removeTable(Table tableInstance) {
        if (tableInstance.eResource() != null) {
            tableInstance.eResource().getContents().remove((Object)tableInstance);
        }
    }

    protected boolean isModelRoot(EObject object) {
        return object instanceof Table;
    }

    public Table getTable(String tableName) throws NotFoundException, BadArgumentExcetion {
        if (tableName == null || tableName.length() == 0) {
            throw new BadArgumentExcetion("Table name should not be null and size should be >0.");
        }
        for (EObject element : this.getResource().getContents()) {
            Table table;
            if (!(element instanceof Table) || !tableName.equals((table = (Table)element).getName())) continue;
            return table;
        }
        throw new NotFoundException(NLS.bind((String)"No Table named '{0}' can be found in Model.", (Object)tableName));
    }
}

