/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.strategy.paste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.nattable.common.commands.InsertTableCommand;
import org.eclipse.papyrus.infra.nattable.common.utils.TableUtil;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class TablePasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    protected static final String TABLE_WITH_NO_OWNER = "TABLE_WITH_NO_OWNER";
    private static IPasteStrategy instance = new TablePasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "Table Strategy";
    }

    public String getID() {
        return "org.eclipse.papyrus.infra.gmfdiag.common.TableStrategy";
    }

    public String getDescription() {
        return "Copy Table";
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand("Copy all tables");
        Map internalClipboardToTargetCopy = papyrusClipboard.getInternalClipboardToTargetCopy();
        Map additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID());
        if (additionalDataMap != null) {
            Object additionalData = additionalDataMap.get(TABLE_WITH_NO_OWNER);
            if (additionalData instanceof TableClipboardAdditionalData) {
                TableClipboardAdditionalData tableAdditionalData = (TableClipboardAdditionalData)additionalData;
                Collection<Table> duplicateTables = tableAdditionalData.getDuplicatedTables(internalClipboardToTargetCopy);
                for (Table table : duplicateTables) {
                    InsertTableCommand command = new InsertTableCommand((TransactionalEditingDomain)domain, "Insert a table whit no source owner", table, targetOwner);
                    compoundCommand.append((Command)command);
                }
            }
            for (Object object : papyrusClipboard) {
                EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                if (target == null || !((additionalData = additionalDataMap.get(object)) instanceof TableClipboardAdditionalData)) continue;
                TableClipboardAdditionalData tableAdditionalData = (TableClipboardAdditionalData)additionalData;
                Collection<Table> duplicateTables = tableAdditionalData.getDuplicatedTables(internalClipboardToTargetCopy);
                for (Table table : duplicateTables) {
                    InsertTableCommand command = new InsertTableCommand((TransactionalEditingDomain)domain, "InsertTableCommand", table, target);
                    compoundCommand.append((Command)command);
                }
            }
        }
        if (compoundCommand.getCommandList().isEmpty()) {
            return null;
        }
        return compoundCommand;
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        Map sourceToInternalClipboard = papyrusClipboard.getSourceToInternalClipboard();
        HashMap<Object, TableClipboardAdditionalData> mapCopyToClipboardAdditionalData = new HashMap<Object, TableClipboardAdditionalData>();
        List<Table> extractSelectedWithoutOwner = this.extractTableWithoutOwner(selection);
        if (extractSelectedWithoutOwner != null && !extractSelectedWithoutOwner.isEmpty()) {
            TableClipboardAdditionalData diagramAdditionnalData = new TableClipboardAdditionalData(extractSelectedWithoutOwner, sourceToInternalClipboard);
            mapCopyToClipboardAdditionalData.put(TABLE_WITH_NO_OWNER, diagramAdditionnalData);
        }
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            ResourceSet resourceSet;
            EObject eObjectSource = (EObject)iterator.next();
            List<Table> associatedTables = TableUtil.getAssociatedTables(eObjectSource, resourceSet = eObjectSource.eResource().getResourceSet());
            if (associatedTables == null) continue;
            TableClipboardAdditionalData tabledAdditionalData = new TableClipboardAdditionalData(associatedTables, sourceToInternalClipboard);
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToClipboardAdditionalData.put(copy, tabledAdditionalData);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToClipboardAdditionalData);
    }

    protected List<Table> extractTableWithoutOwner(Collection<EObject> selection) {
        ArrayList<Table> tableWithoutOwnerInSelection = new ArrayList<Table>();
        if (selection != null) {
            for (EObject eObject : selection) {
                Table table;
                EObject element;
                if (!(eObject instanceof Table) || selection.contains(element = (table = (Table)eObject).getOwner())) continue;
                tableWithoutOwnerInSelection.add(table);
            }
        }
        return tableWithoutOwnerInSelection;
    }

    protected static class TableClipboardAdditionalData
    implements IClipboardAdditionalData {
        protected Collection<Table> tables;

        public TableClipboardAdditionalData(Collection<Table> tables, Map<? extends EObject, ? extends EObject> alreadyCopied) {
            this.tables = this.duplicateTables(tables, alreadyCopied);
        }

        public Collection<Table> getDuplicatedTables(Map<? extends EObject, ? extends EObject> alreadyCopied) {
            return this.duplicateTables(this.tables, alreadyCopied);
        }

        protected Collection<Table> duplicateTables(Collection<Table> tables, Map<? extends EObject, ? extends EObject> alreadyCopied) {
            ArrayList<Table> duplicatedTables = new ArrayList<Table>();
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.putAll(alreadyCopied);
            for (Table table : tables) {
                copier.copy((EObject)table);
                copier.copyReferences();
                EObject copy = (EObject)copier.get((Object)table);
                if (!(copy instanceof Table)) continue;
                duplicatedTables.add((Table)copy);
            }
            return duplicatedTables;
        }
    }
}

