/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.converter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.StringResolutionProblem;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;

public class StringResolutionProblemPapyrusConverter
implements IPapyrusConverter {
    private IPapyrusConverter wrappedDisplayConverter;

    public StringResolutionProblemPapyrusConverter(IPapyrusConverter displayConverter) {
        this.wrappedDisplayConverter = displayConverter;
    }

    public List<?> getMatchingElements(String aString) {
        return this.wrappedDisplayConverter.getMatchingElements(aString);
    }

    public List<?> getElementsByName(String aString) {
        return this.wrappedDisplayConverter.getElementsByName(aString);
    }

    public List<String> getShortestQualifiedNames(Object element) {
        return this.wrappedDisplayConverter.getShortestQualifiedNames(element);
    }

    public Map<List<Integer>, String> getSubStringsWithTheirPositions(String multiValueAsString) {
        return this.wrappedDisplayConverter.getSubStringsWithTheirPositions(multiValueAsString);
    }

    public List<String> splitFullStringToSubElementString(String multiValueAsString) {
        return this.wrappedDisplayConverter.splitFullStringToSubElementString(multiValueAsString);
    }

    public IStatus isValidEditString(String aString) {
        return this.wrappedDisplayConverter.isValidEditString(aString);
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return this.wrappedDisplayConverter.getCompletionProcessor(element);
    }

    public String canonicalToDisplayValue(Object object, int flag) {
        return this.wrappedDisplayConverter.canonicalToDisplayValue(object, flag);
    }

    public String canonicalToEditValue(Object object, int flag) {
        if (object == null || "".equals(object)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            if (coll.isEmpty()) {
                return "";
            }
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object tmp = iter.next();
                if (tmp instanceof StringResolutionProblem) {
                    builder.append(((StringResolutionProblem)tmp).getValueAsString());
                }
                if (!iter.hasNext()) continue;
                builder.append(",");
            }
        } else if (object instanceof StringResolutionProblem) {
            builder.append(((StringResolutionProblem)object).getValueAsString());
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return this.wrappedDisplayConverter.canonicalToEditValue(object, flag);
    }

    public Object displayToCanonicalValue(String string, int flag) {
        return this.wrappedDisplayConverter.displayToCanonicalValue(string, flag);
    }

    public Object editToCanonicalValue(String string, int flag) {
        return this.wrappedDisplayConverter.editToCanonicalValue(string, flag);
    }

    public String editToDisplayValue(String string) {
        return this.wrappedDisplayConverter.editToDisplayValue(string);
    }

    public String displayToEditValue(String string) {
        return this.wrappedDisplayConverter.displayToEditValue(string);
    }
}

