/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;

public abstract class AbstractMergeHandler
extends AbstractTableHandler {
    protected void executeMergeCommands(CompositeCommand mergeCommand, TransactionalEditingDomain tableDomain) {
        if (!mergeCommand.isEmpty()) {
            tableDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)mergeCommand));
        }
    }

    protected void updateTableSpanBooleans(String commandId, CompositeCommand mergeCommand) {
        TransactionalEditingDomain tableDomain = this.getTableEditingDomain();
        BooleanValueStyle mergeRows = (BooleanValueStyle)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(this.getTable()).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeRows");
        BooleanValueStyle mergeColumns = (BooleanValueStyle)HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.getTable()).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeColumns");
        if (mergeRows != null && mergeRows.isBooleanValue() && !commandId.equals("org.eclipse.papyrus.infra.nattable.mergeRows")) {
            SetRequest mergeRowRequest = new SetRequest(tableDomain, (EObject)mergeRows, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
            SetValueCommand mergeRowCommand = new SetValueCommand(mergeRowRequest);
            mergeCommand.add((IUndoableOperation)mergeRowCommand);
        }
        if (mergeColumns != null && mergeColumns.isBooleanValue() && !commandId.equals("org.eclipse.papyrus.infra.nattable.mergeColumns")) {
            SetRequest mergeColumnRequest = new SetRequest(tableDomain, (EObject)mergeColumns, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
            SetValueCommand mergeColumnCommand = new SetValueCommand(mergeColumnRequest);
            mergeCommand.add((IUndoableOperation)mergeColumnCommand);
        }
    }

    protected void updateAxisSpanBooleans(String commandId, CompositeCommand mergeCommand) {
        SetValueCommand mergeColumnBooleanCommand;
        SetRequest mergeColumnBooleanRequest;
        SetValueCommand mergeRowBooleanCommand;
        SetRequest mergeRowBooleanRequest;
        TransactionalEditingDomain tableDomain = this.getTableEditingDomain();
        EList rowIAxisList = this.getTable().getCurrentRowAxisProvider().getAxis();
        EList columnIAxisList = this.getTable().getCurrentColumnAxisProvider().getAxis();
        for (IAxis currentAxis : rowIAxisList) {
            BooleanValueStyle mergeRowBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows");
            BooleanValueStyle mergeColumnBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns");
            if (mergeRowBoolean != null && mergeRowBoolean.isBooleanValue() && !this.getTable().isInvertAxis()) {
                mergeRowBooleanRequest = new SetRequest(tableDomain, (EObject)mergeRowBoolean, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
                mergeRowBooleanCommand = new SetValueCommand(mergeRowBooleanRequest);
                mergeCommand.add((IUndoableOperation)mergeRowBooleanCommand);
            }
            if (mergeColumnBoolean == null || !mergeColumnBoolean.isBooleanValue() || !this.getTable().isInvertAxis()) continue;
            mergeColumnBooleanRequest = new SetRequest(tableDomain, (EObject)mergeColumnBoolean, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
            mergeColumnBooleanCommand = new SetValueCommand(mergeColumnBooleanRequest);
            mergeCommand.add((IUndoableOperation)mergeColumnBooleanCommand);
        }
        for (IAxis currentAxis : columnIAxisList) {
            BooleanValueStyle mergeColumnBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns");
            BooleanValueStyle mergeRowBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows");
            if (mergeColumnBoolean != null && mergeColumnBoolean.isBooleanValue() && !this.getTable().isInvertAxis()) {
                mergeColumnBooleanRequest = new SetRequest(tableDomain, (EObject)mergeColumnBoolean, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
                mergeColumnBooleanCommand = new SetValueCommand(mergeColumnBooleanRequest);
                mergeCommand.add((IUndoableOperation)mergeColumnBooleanCommand);
            }
            if (mergeRowBoolean == null || !mergeRowBoolean.isBooleanValue() || !this.getTable().isInvertAxis()) continue;
            mergeRowBooleanRequest = new SetRequest(tableDomain, (EObject)mergeRowBoolean, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
            mergeRowBooleanCommand = new SetValueCommand(mergeRowBooleanRequest);
            mergeCommand.add((IUndoableOperation)mergeRowBooleanCommand);
        }
    }
}

