/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.tools.util.WorkbenchPartHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractTableHandler
extends AbstractHandler {
    public static final String NAT_EVENT_DATA_PARAMETER_ID = "natEventParameterId";
    private WeakReference<NatEventData> eventDataWeakReference;

    protected IWorkbenchPart getActivePart() {
        return WorkbenchPartHelper.getCurrentActiveWorkbenchPart();
    }

    protected final TableSelectionWrapper getTableSelectionWrapper(Object evaluationContextOrExecutionEvent) {
        IWorkbenchPart p;
        ISelection selection;
        if (evaluationContextOrExecutionEvent instanceof IEvaluationContext) {
            Object selection2 = HandlerUtil.getVariable((Object)evaluationContextOrExecutionEvent, (String)"selection");
            if (selection2 instanceof IAdaptable) {
                return (TableSelectionWrapper)((IAdaptable)selection2).getAdapter(TableSelectionWrapper.class);
            }
        } else if (evaluationContextOrExecutionEvent instanceof ExecutionEvent && (selection = (ISelection)(p = HandlerUtil.getActivePart((ExecutionEvent)((ExecutionEvent)evaluationContextOrExecutionEvent))).getAdapter(ISelection.class)) instanceof TableStructuredSelection) {
            return (TableSelectionWrapper)((TableStructuredSelection)selection).getAdapter(TableSelectionWrapper.class);
        }
        return null;
    }

    protected INattableModelManager getCurrentNattableModelManager() {
        IWorkbenchPart currentPart = this.getActivePart();
        if (currentPart != null) {
            INattableModelManager manager = (INattableModelManager)currentPart.getAdapter(INattableModelManager.class);
            return manager;
        }
        return null;
    }

    protected TransactionalEditingDomain getTableEditingDomain() {
        return TableEditingDomainUtils.getTableEditingDomain(this.getCurrentNattableModelManager().getTable());
    }

    protected TransactionalEditingDomain getContextEditingDomain() {
        return TableEditingDomainUtils.getTableContextEditingDomain(this.getCurrentNattableModelManager().getTable());
    }

    protected NatEventData getNatEventData() {
        if (this.eventDataWeakReference != null) {
            return (NatEventData)this.eventDataWeakReference.get();
        }
        return null;
    }

    protected NatEventData getNatEventData(Object evaluationContext) {
        Object value;
        if (evaluationContext instanceof NatEventData) {
            return (NatEventData)evaluationContext;
        }
        NatEventData eventData = null;
        if (evaluationContext instanceof IEvaluationContext && (value = ((IEvaluationContext)evaluationContext).getVariable(NAT_EVENT_DATA_PARAMETER_ID)) instanceof NatEventData) {
            eventData = (NatEventData)value;
        }
        if (eventData == null) {
            Point cursorLocation = Display.getDefault().getCursorLocation();
            Control control = Display.getDefault().getCursorControl();
            if (control instanceof NatTable) {
                cursorLocation = control.toControl(cursorLocation);
                Event e = new Event();
                e.x = cursorLocation.x;
                e.y = cursorLocation.y;
                e.display = Display.getDefault();
                e.widget = control;
                MouseEvent event = new MouseEvent(e);
                eventData = NatEventData.createInstanceFromEvent((MouseEvent)event);
            }
        }
        return eventData;
    }

    protected List<Integer> getFullSelectedRowsIndex(Object evaluationContext) {
        NatEventData data;
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null && (data = this.getNatEventData(evaluationContext)) != null) {
            SelectionLayer layer = manager.getBodyLayerStack().getSelectionLayer();
            int[] fullSelectedColumnsPosition = layer.getFullySelectedRowPositions();
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int[] nArray = fullSelectedColumnsPosition;
            int n = fullSelectedColumnsPosition.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                positions.add(layer.getRowIndexByPosition(i));
                ++n2;
            }
            return positions;
        }
        return Collections.emptyList();
    }

    protected List<Integer> getFullSelectedColumnsIndex(Object evaluationContext) {
        NatEventData data;
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null && (data = this.getNatEventData(evaluationContext)) != null) {
            SelectionLayer layer = manager.getBodyLayerStack().getSelectionLayer();
            int[] fullSelectedColumnsPosition = layer.getFullySelectedColumnPositions();
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int[] nArray = fullSelectedColumnsPosition;
            int n = fullSelectedColumnsPosition.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                positions.add(layer.getColumnIndexByPosition(i));
                ++n2;
            }
            return positions;
        }
        return Collections.emptyList();
    }

    protected IAxisManager getRowAxisManager() {
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null) {
            return manager.getRowAxisManager();
        }
        return null;
    }

    protected IAxisManager getColumnAxisManager() {
        INattableModelManager manager = this.getCurrentNattableModelManager();
        if (manager != null) {
            return manager.getColumnAxisManager();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.eventDataWeakReference = new WeakReference<NatEventData>(this.getNatEventData(evaluationContext));
        boolean enabled = this.getCurrentNattableModelManager() != null;
        this.setBaseEnabled(enabled);
    }

    protected void setBaseEnabled(boolean state) {
        if (!state) {
            this.eventDataWeakReference = null;
        }
        super.setBaseEnabled(state);
    }

    protected final Table getTable() {
        return this.getCurrentNattableModelManager().getTable();
    }

    protected final void refreshTable() {
        ((NattableModelManager)this.getCurrentNattableModelManager()).refreshNatTable();
    }

    public void dispose() {
        super.dispose();
        this.eventDataWeakReference = null;
    }
}

