/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.LocationValue;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;

public class NatTableDropListener
implements DropTargetListener {
    private final INattableModelManager manager;
    private final ISelectionExtractor selectionExtractor;
    private LocationValue dropKindValue;

    public NatTableDropListener(INattableModelManager manager, ISelectionExtractor selectionExtractor) {
        this.manager = manager;
        this.selectionExtractor = selectionExtractor;
    }

    public void dragEnter(DropTargetEvent event) {
        this.validateDropEvent(event);
    }

    protected void validateDropEvent(DropTargetEvent event) {
        event.operations = 3;
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.validateDropEvent(event);
    }

    public void dragOver(DropTargetEvent event) {
        this.validateDropEvent(event);
        this.dropKindValue = null;
        List<Object> droppedElements = this.getDroppedObjects(event);
        if (droppedElements.isEmpty()) {
            return;
        }
        this.dropKindValue = this.manager.getLocationInTheTable(new Point(event.x, event.y));
        int drop = 0;
        switch (this.dropKindValue.getKind()) {
            case AFTER_COLUMN_HEADER: {
                if (!this.manager.canDropColumnsElement(droppedElements)) break;
                drop = event.detail;
                break;
            }
            case AFTER_ROW_HEADER: {
                if (!this.manager.canDropRowElement(droppedElements)) break;
                drop = event.detail;
                break;
            }
            case COLUMN_HEADER: {
                if (!this.manager.canInsertColumns(droppedElements, this.dropKindValue.getColumnIndex())) break;
                drop = event.detail;
                break;
            }
            case ROW_HEADER: {
                if (!this.manager.canInsertRow(droppedElements, this.dropKindValue.getRowIndex())) break;
                drop = event.detail;
                break;
            }
            case CELL: {
                TransactionalEditingDomain domain;
                Command cmd;
                int rowIndex = this.dropKindValue.getRowIndex();
                int columnIndex = this.dropKindValue.getColumnIndex();
                Object rowElement = this.manager.getRowElement(rowIndex);
                Object columnElement = this.manager.getColumnElement(columnIndex);
                if (!CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement) || (cmd = this.getDropSetValueCommand(domain = this.getEditingDomain(), droppedElements)) == null || !cmd.canExecute()) break;
                drop = event.detail;
                break;
            }
            case UNKNOWN: {
                drop = 0;
                break;
            }
            default: {
                drop = 0;
            }
        }
        event.detail = drop;
    }

    protected List<Object> getDroppedObjects(DropTargetEvent event) {
        ISelection selection;
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Object data = localTransfer.nativeToJava(event.currentDataType);
        IStructuredSelection structuredSelection = null;
        if (data instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)data;
        } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
        }
        if (structuredSelection == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(this.extractSelectedObjects(structuredSelection));
    }

    protected Collection<?> extractSelectedObjects(IStructuredSelection structuredSelection) {
        return this.selectionExtractor.extractSelectedObjects(structuredSelection);
    }

    private Command getDropSetValueCommand(TransactionalEditingDomain domain, List<Object> droppedElements) {
        int rowIndex = this.dropKindValue.getRowIndex();
        int columnIndex = this.dropKindValue.getColumnIndex();
        Object rowElement = this.manager.getRowElement(rowIndex);
        Object columnElement = this.manager.getColumnElement(columnIndex);
        if (CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement)) {
            Object newValue = null;
            Object currentValue = CellManagerFactory.INSTANCE.getCrossValueIgnoringProblems(columnElement, rowElement, this.manager);
            if (currentValue instanceof Collection) {
                ArrayList<Object> tmpNewValue = new ArrayList<Object>();
                tmpNewValue.addAll((Collection)currentValue);
                tmpNewValue.addAll(droppedElements);
                newValue = tmpNewValue;
            } else {
                newValue = droppedElements.size() == 1 ? droppedElements.get(0) : droppedElements;
            }
            Command cmd = CellManagerFactory.INSTANCE.getSetCellValueCommand(domain, columnElement, rowElement, newValue, this.manager);
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void drop(DropTargetEvent event) {
        List<Object> droppedElements = this.getDroppedObjects(event);
        if (!droppedElements.isEmpty() && this.dropKindValue != null) {
            switch (this.dropKindValue.getKind()) {
                case AFTER_COLUMN_HEADER: {
                    this.manager.addColumns(droppedElements);
                    break;
                }
                case AFTER_ROW_HEADER: {
                    this.manager.addRows(droppedElements);
                    break;
                }
                case COLUMN_HEADER: {
                    this.manager.insertColumns(droppedElements, this.dropKindValue.getColumnIndex());
                    break;
                }
                case ROW_HEADER: {
                    this.manager.insertRows(droppedElements, this.dropKindValue.getRowIndex());
                    break;
                }
                case CELL: {
                    TransactionalEditingDomain domain = this.getEditingDomain();
                    Command cmd = this.getDropSetValueCommand(domain, droppedElements);
                    if (cmd == null || !cmd.canExecute()) break;
                    domain.getCommandStack().execute(cmd);
                    break;
                }
                case UNKNOWN: {
                    break;
                }
            }
        }
        this.dropKindValue = null;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain domain = null;
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.manager.getTable().getContext());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (registry != null) {
            try {
                domain = (TransactionalEditingDomain)registry.getService(TransactionalEditingDomain.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return domain;
    }
}

