/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.infra.nattable.configuration.TreeTableClickSortConfiguration;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderHierarchicalLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderLayerStack;
import org.eclipse.papyrus.infra.nattable.listener.HideShowCategoriesTableListener;
import org.eclipse.papyrus.infra.nattable.manager.axis.AxisManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeTreeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ITreeItemAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.selection.ObjectsSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.tree.CollapseAndExpandActionsEnum;
import org.eclipse.papyrus.infra.nattable.tree.DatumExpansionModel;
import org.eclipse.papyrus.infra.nattable.tree.DatumTreeFormat;
import org.eclipse.papyrus.infra.nattable.utils.CollapseExpandActionHelper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.tools.util.EclipseCommandUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;

public class TreeNattableModelManager
extends NattableModelManager
implements ITreeNattableModelManager {
    protected TreeList treeList;
    protected DatumTreeFormat treeFormat;
    protected DatumExpansionModel expansionModel;
    protected ResourceSetListener hideShowCategoriesListener;

    public TreeNattableModelManager(Table rawModel, ISelectionExtractor selectionExtractor) {
        super(rawModel, selectionExtractor);
        Assert.isTrue((boolean)TableHelper.isTreeTable(rawModel));
    }

    public TreeNattableModelManager(Table rawModel) {
        this(rawModel, new ObjectsSelectionExtractor());
    }

    @Override
    protected List<Object> createHorizontalElementList() {
        EventList eventList = GlazedLists.eventList(new ArrayList());
        this.basicHorizontalList = eventList = GlazedLists.threadSafeList((EventList)eventList);
        this.rowSortedList = new SortedList(this.basicHorizontalList, null);
        this.treeFormat = new DatumTreeFormat(this.getRowSortModel());
        this.expansionModel = new DatumExpansionModel();
        this.horizontalFilterList = new FilterList((EventList)this.rowSortedList);
        this.treeList = new TreeList((EventList)this.horizontalFilterList, (TreeList.Format)this.treeFormat, (TreeList.ExpansionModel)this.expansionModel);
        return this.treeList;
    }

    @Override
    public TreeList getTreeList() {
        return this.treeList;
    }

    @Override
    public NatTable createNattable(Composite parent, int style, IWorkbenchPartSite site) {
        NatTable nattable = super.createNattable(parent, style, site);
        List<Integer> hiddenDepth = StyleUtils.getHiddenDepths(this);
        if (hiddenDepth.size() > 0) {
            this.hideShowCategories(hiddenDepth, null);
        }
        this.hideShowCategoriesListener = new HideShowCategoriesTableListener(this);
        if (this.getTableEditingDomain() != null) {
            this.getTableEditingDomain().addResourceSetListener(this.hideShowCategoriesListener);
        }
        if (StyleUtils.hasAppliedFilter(this)) {
            this.doCollapseExpandAction(CollapseAndExpandActionsEnum.EXPAND_ALL, null);
        }
        return nattable;
    }

    @Override
    protected void addClickSortConfiguration(NatTable natTable) {
        natTable.addConfiguration((IConfiguration)new TreeTableClickSortConfiguration());
    }

    @Override
    protected void updateToggleActionState() {
        super.updateToggleActionState();
        DisplayStyle style = TableHelper.getTableDisplayStyle(this);
        ICommandService commandService = EclipseCommandUtils.getCommandService();
        if (commandService != null) {
            Command command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.table.hierarchic.style");
            if (!DisplayStyle.NORMAL.equals((Object)style)) {
                this.updateRadioCommandState(command, style.getLiteral());
            }
        }
    }

    @Override
    protected ICompositeAxisManager createAxisManager(List<AxisManagerRepresentation> representations, AbstractAxisProvider contentProvider, boolean columnAxisManager) {
        if (columnAxisManager) {
            return super.createAxisManager(representations, contentProvider, columnAxisManager);
        }
        CompositeTreeAxisManagerForEventList compositeAxisManager = new CompositeTreeAxisManagerForEventList((EventList<Object>)this.horizontalFilterList);
        ArrayList<IAxisManagerForEventList> managers = new ArrayList<IAxisManagerForEventList>();
        for (AxisManagerRepresentation current : representations) {
            IAxisManager manager = AxisManagerFactory.INSTANCE.getAxisManager(current);
            Assert.isTrue((boolean)(manager instanceof IAxisManagerForEventList));
            manager.init(this, current, contentProvider);
            managers.add((IAxisManagerForEventList)manager);
        }
        compositeAxisManager.init(this, null, contentProvider);
        DatumTreeFormat treeFormat = this.getTreeFormat();
        treeFormat.setTreeComparatorProvider(compositeAxisManager);
        this.expansionModel.setAxisManager(compositeAxisManager);
        ((CompositeAxisManagerForEventList)compositeAxisManager).setSubManagers(managers);
        return compositeAxisManager;
    }

    @Override
    public DatumTreeFormat getTreeFormat() {
        return this.treeFormat;
    }

    @Override
    public int getTreeItemDepth(ITreeItemAxis axis) {
        DatumTreeFormat format = this.getTreeFormat();
        if (format != null) {
            ArrayList path = new ArrayList();
            format.getPath(path, axis);
            return path.size() - 1;
        }
        return 0;
    }

    @Override
    public int getSemanticDepth(ITreeItemAxis axis) {
        Object representedObject = axis.getElement();
        if (representedObject instanceof TreeFillingConfiguration) {
            return ((TreeFillingConfiguration)representedObject).getDepth();
        }
        ITreeItemAxis parent = axis.getParent();
        if (parent == null) {
            return 0;
        }
        representedObject = parent.getElement();
        Assert.isTrue((boolean)(representedObject instanceof TreeFillingConfiguration));
        return ((TreeFillingConfiguration)representedObject).getDepth();
    }

    @Override
    public void hideShowCategories(List<Integer> depthToHide, List<Integer> depthToShow) {
        this.hideShowRowCategories(depthToHide, depthToShow);
        this.hideShowColumnCategoriesInRowHeader(depthToHide, depthToShow);
    }

    @Override
    public void hideShowRowCategories(List<Integer> depthToHide, List<Integer> depthToShow) {
        ((ITreeItemAxisManagerForEventList)this.getRowAxisManager()).managedHideShowCategoriesForDepth(depthToHide, depthToShow);
    }

    @Override
    public void hideShowColumnCategoriesInRowHeader(List<Integer> depthToHide, List<Integer> depthToShow) {
        this.natTable.refresh();
        RowHeaderLayerStack rowHeaderLayerStack = this.getRowHeaderLayerStack();
        if (rowHeaderLayerStack instanceof RowHeaderHierarchicalLayerStack) {
            ColumnHideShowLayer layer = ((RowHeaderHierarchicalLayerStack)rowHeaderLayerStack).getRowHeaderColumnHideShowLayer();
            ILayer subLayer = layer.getUnderlyingLayerByPosition(0, 0);
            if (TableHelper.isMultiColumnTreeTable(this)) {
                int tmp;
                Integer curr;
                int i;
                boolean hasRootConfif = FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), 0);
                if (depthToHide != null && depthToHide.size() > 0) {
                    int[] indexToHide = new int[depthToHide.size()];
                    i = 0;
                    while (i < depthToHide.size()) {
                        curr = depthToHide.get(i);
                        tmp = -1;
                        tmp = hasRootConfif ? curr * 2 : curr * 2 - 1;
                        indexToHide[i] = tmp = layer.underlyingToLocalColumnPosition(subLayer, tmp);
                        ++i;
                    }
                    layer.doCommand((ILayerCommand)new MultiColumnHideCommand((ILayer)layer, indexToHide));
                }
                if (depthToShow != null && depthToShow.size() > 0) {
                    ArrayList<Integer> indexToShow = new ArrayList<Integer>();
                    i = 0;
                    while (i < depthToShow.size()) {
                        curr = depthToShow.get(i);
                        tmp = -1;
                        tmp = hasRootConfif ? curr * 2 : curr * 2 - 1;
                        indexToShow.add(tmp);
                        ++i;
                    }
                    layer.doCommand((ILayerCommand)new MultiColumnShowCommand(indexToShow));
                }
            } else {
                layer.doCommand((ILayerCommand)new ShowAllColumnsCommand());
            }
        }
    }

    @Override
    protected RowHeaderLayerStack createRowHeaderLayerStack(BodyLayerStack bodyLayerStack) {
        return new RowHeaderHierarchicalLayerStack(bodyLayerStack, this);
    }

    @Override
    public void doCollapseExpandAction(CollapseAndExpandActionsEnum actionId, List<ITreeItemAxis> selectedAxis) {
        CollapseExpandActionHelper.doCollapseExpandAction(actionId, selectedAxis, this.getTableAxisElementProvider(), this.natTable);
    }

    @Override
    protected Adapter createInvertAxisListener() {
        return null;
    }

    private void modifyAcisDeliver(List<IAxis> iAxis) {
        for (IAxis axis : iAxis) {
            if (!(axis instanceof ITreeItemAxis)) continue;
            boolean isDelivering = axis.eDeliver();
            if (isDelivering) {
                axis.eSetDeliver(false);
            }
            ((ITreeItemAxis)axis).getChildren().clear();
            if (!isDelivering) continue;
            axis.eSetDeliver(true);
        }
    }

    @Override
    public void dispose() {
        EList iAxis;
        if (this.getTableEditingDomain() != null && this.hideShowCategoriesListener != null) {
            this.getTableEditingDomain().removeResourceSetListener(this.hideShowCategoriesListener);
            this.hideShowCategoriesListener = null;
        }
        if ((iAxis = this.getHorizontalAxisProvider() == null ? null : this.getHorizontalAxisProvider().getAxis()) != null && !iAxis.isEmpty()) {
            Runnable runnable = new Runnable((List)iAxis){
                private final /* synthetic */ List val$iAxis;
                {
                    this.val$iAxis = list;
                }

                @Override
                public void run() {
                    TreeNattableModelManager.this.modifyAcisDeliver(this.val$iAxis);
                }
            };
            try {
                if (this.getTableEditingDomain() != null) {
                    GMFUnsafe.write((TransactionalEditingDomain)this.getTableEditingDomain(), (Runnable)runnable);
                } else {
                    this.modifyAcisDeliver((List<IAxis>)iAxis);
                }
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
            catch (RollbackException e) {
                Activator.log.error((Throwable)e);
            }
        }
        if (this.getTableEditingDomain() != null && this.hideShowCategoriesListener != null) {
            this.getTableEditingDomain().removeResourceSetListener(this.hideShowCategoriesListener);
        }
        super.dispose();
    }
}

