/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.ITreeSelectorDialog;

public class SetTargetAndRelationshipCommand
extends AbstractCommand {
    private IElementEditService provider;
    private EReference reference;
    private EObject source;
    private ITreeSelectorDialog dialog;
    private IElementType elementType;
    private TransactionalEditingDomain ted;
    private GMFtoEMFCommandWrapper emfCommand;

    public SetTargetAndRelationshipCommand(TransactionalEditingDomain ted, String label, IElementEditService provider, EReference reference, EObject source, IElementType et, ITreeSelectorDialog dialog) {
        super(label);
        this.provider = provider;
        this.reference = reference;
        this.source = source;
        this.elementType = et;
        this.ted = ted;
        this.dialog = dialog;
    }

    public boolean canExecute() {
        CreateElementRequest buildRequest = this.buildRequest(null);
        ICommand createGMFCommand = this.provider.getEditCommand((IEditCommandRequest)buildRequest);
        if (createGMFCommand == null) {
            return false;
        }
        boolean canExecute = createGMFCommand.canExecute();
        return canExecute;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        int returnCode = this.dialog.open();
        if (returnCode == 0) {
            Object[] targetComponents = this.dialog.getResult();
            EObject element = (EObject)targetComponents[0];
            CreateElementRequest buildRequest = this.buildRequest(element);
            ICommand createGMFCommand = this.provider.getEditCommand((IEditCommandRequest)buildRequest);
            if (createGMFCommand == null || createGMFCommand instanceof UnexecutableCommand) {
                throw new OperationCanceledException();
            }
            this.emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            this.emfCommand.execute();
            CommandResult commandResult = createGMFCommand.getCommandResult();
            return commandResult;
        }
        throw new OperationCanceledException();
    }

    private CreateElementRequest buildRequest(EObject element) {
        CreateRelationshipRequest buildRequest = null;
        buildRequest = this.reference == null ? new CreateRelationshipRequest(this.ted, null, this.source, element, this.elementType) : new CreateRelationshipRequest(this.ted, null, this.source, element, this.elementType, this.reference);
        return buildRequest;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.emfCommand.redo();
        return null;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.emfCommand.undo();
        return null;
    }

    public boolean canUndo() {
        return this.emfCommand != null;
    }

    public boolean canRedo() {
        return this.emfCommand != null;
    }
}

