/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.newchild.CreationMenuFactory;
import org.eclipse.papyrus.infra.newchild.CreationMenuRegistry;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Folder;
import org.eclipse.papyrus.infra.services.edit.utils.RequestCacheEntries;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public class DynamicNewChild
extends ContributionItem {
    protected TransactionalEditingDomain editingDomain;
    protected CreationMenuRegistry creationMenuRegistry = new CreationMenuRegistry();

    public DynamicNewChild() {
    }

    public DynamicNewChild(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        return new IContributionItem[0];
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        EObject eObject = this.getSelection();
        if (eObject != null && this.editingDomain != null) {
            HashMap adviceCache = new HashMap();
            try {
                RequestCacheEntries.initializeEObjCache((EObject)eObject, adviceCache);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            CreationMenuFactory creationMenuFactory = new CreationMenuFactory(this.editingDomain);
            ArrayList<Folder> folders = this.creationMenuRegistry.getRootFolder();
            for (Folder currentFolder : folders) {
                boolean hasbeenBuild = creationMenuFactory.populateMenu(menu, currentFolder, eObject, index, adviceCache);
                if (!hasbeenBuild) continue;
                ++index;
            }
        } else {
            super.fill(menu, index);
        }
    }

    protected EObject getSelection() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        if (selectionService == null) {
            return null;
        }
        ISelection selection = selectionService.getSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            ITreeSelection treeSel;
            TreePath[] paths;
            Object selectedobject = ((IStructuredSelection)selection).getFirstElement();
            EObject selectedEObject = EMFHelper.getEObject((Object)selectedobject);
            EObject editingDomainCitizen = selectedEObject;
            if (editingDomainCitizen instanceof EReference && selection instanceof ITreeSelection && (paths = (treeSel = (ITreeSelection)selection).getPathsFor(selectedobject)) != null && paths.length > 0 && paths[0].getSegmentCount() > 1) {
                editingDomainCitizen = EMFHelper.getEObject((Object)paths[0].getSegment(paths[0].getSegmentCount() - 2));
            }
            try {
                this.editingDomain = (TransactionalEditingDomain)ServiceUtilsForEObject.getInstance().getService(TransactionalEditingDomain.class, (Object)editingDomainCitizen);
            }
            catch (Exception ex) {
                this.editingDomain = TransactionUtil.getEditingDomain((EObject)editingDomainCitizen);
            }
            return selectedEObject;
        }
        return null;
    }
}

