/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;

public class LoadDiagramCommand
implements Runnable {
    private IPageManager pageManager;
    private URI uri;

    public LoadDiagramCommand() {
    }

    public LoadDiagramCommand(Resource resource) {
        try {
            this.pageManager = ServiceUtilsForResource.getInstance().getIPageManager((Object)resource);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.uri = resource.getURI();
    }

    public void run() {
        URI uriTrimResource;
        List pagesID;
        if (this.pageManager != null && (pagesID = this.pageManager.getAssociatedPages((Object)(uriTrimResource = this.uri.trimFragment().trimFileExtension()))).size() > 0) {
            for (Object pageID : pagesID) {
                if (pageID == null) continue;
                this.pageManager.reloadPage(pageID);
            }
        }
    }
}

