/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.listener;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.service.IUncontrolledObjectsProvider;

public class UncontrolModeSaveListener
implements ISaveEventListener {
    private IUncontrolledObjectsProvider service = null;

    public UncontrolModeSaveListener(IUncontrolledObjectsProvider serviceUncontrolledObject) {
        this.service = serviceUncontrolledObject;
    }

    public void doSaveAs(DoSaveEvent event) {
        this.doSave(event);
    }

    /*
     * Loose catch block
     */
    public void doSave(DoSaveEvent event) {
        block10: {
            if (this.service.hasUncontrolledObjects()) {
                try {
                    try {
                        TransactionalEditingDomain editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)event.getServiceRegistry());
                        TransactionHelper.run((TransactionalEditingDomain)editingDomain, (Runnable)new UncontrolledObjectCommand(this.service));
                    }
                    catch (ServiceException e) {
                        ControlModePlugin.log.error((Throwable)e);
                        this.service.clear();
                    }
                    catch (InterruptedException e) {
                        ControlModePlugin.log.error((Throwable)e);
                        this.service.clear();
                    }
                    catch (RollbackException e) {
                        ControlModePlugin.log.error((Throwable)e);
                        this.service.clear();
                        break block10;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    this.service.clear();
                }
            }
        }
    }

    public class UncontrolledObjectCommand
    implements Runnable {
        private IUncontrolledObjectsProvider uncontrolledEObjectService;

        public UncontrolledObjectCommand(IUncontrolledObjectsProvider service) {
            this.uncontrolledEObjectService = service;
        }

        public void run() {
            Iterator<Resource> resourcesIterator = this.uncontrolledEObjectService.getResources();
            while (resourcesIterator.hasNext()) {
                Resource resource = resourcesIterator.next();
                List<EObject> resourceUncontrolledObject = this.uncontrolledEObjectService.getResourceUncontrolledObject(resource);
                resource.getContents().removeAll(resourceUncontrolledObject);
            }
        }
    }
}

