/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingInvocationHandler;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.infra.tools.databinding.IDelegatingObservable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingObservableValue
extends DelegatingObservable<IObservableValue>
implements IObservableValue {
    private static final Object VALUE_EVENT_TYPE = new Object();
    private IValueChangeListener forwardingValueChangeListener;

    DelegatingObservableValue(IObservableValue delegate) {
        super(delegate, IObservableValue.class);
    }

    DelegatingObservableValue(Realm realm) {
        super(realm, IObservableValue.class);
    }

    public static IObservableValue wrap(IObservableValue observable) {
        IObservableValue result;
        if (observable instanceof IDelegatingObservable) {
            try {
                result = (IObservableValue)observable.getClass().getDeclaredConstructor(IObservableValue.class).newInstance(observable);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("observable is an invalid implementation of IDelegatingObservable", e);
            }
        } else {
            result = DelegatingInvocationHandler.wrap(new DelegatingObservableValue(observable), IObservableValue.class);
        }
        return result;
    }

    public static IObservableValue create(Realm realm, ClassLoader loader, Class<?> ... mixins) {
        return DelegatingInvocationHandler.wrap(new DelegatingObservableValue(realm), IObservableValue.class, loader, mixins);
    }

    public void addValueChangeListener(IValueChangeListener listener) {
        this.addListener(VALUE_EVENT_TYPE, (IObservablesListener)listener);
    }

    public void removeValueChangeListener(IValueChangeListener listener) {
        this.removeListener(VALUE_EVENT_TYPE, (IObservablesListener)listener);
    }

    @Override
    protected void hookDelegate(IObservableValue delegate) {
        super.hookDelegate(delegate);
        delegate.addValueChangeListener(this.getForwardingValueChangeListener());
    }

    @Override
    protected void unhookDelegate(IObservableValue delegate) {
        delegate.removeValueChangeListener(this.getForwardingValueChangeListener());
        super.unhookDelegate(delegate);
    }

    @Override
    protected void delegateChanged(IObservableValue oldDelegate, IObservableValue newDelegate) {
        super.delegateChanged(oldDelegate, newDelegate);
        Object oldValue = oldDelegate == null || oldDelegate.isDisposed() ? null : oldDelegate.getValue();
        Object newValue = newDelegate == null ? null : newDelegate.getValue();
        this.fireEvent((ObservableEvent)new MyValueChangeEvent(Diffs.createValueDiff((Object)oldValue, (Object)newValue)));
    }

    public Object getValueType() {
        return this.getDelegate() == null ? Void.class : ((IObservableValue)this.getDelegate()).getValueType();
    }

    public Object getValue() {
        this.getterCalled();
        return this.getDelegate() == null ? null : ((IObservableValue)this.getDelegate()).getValue();
    }

    public void setValue(Object value) {
        if (this.getDelegate() != null) {
            ((IObservableValue)this.getDelegate()).setValue(value);
        }
    }

    private IValueChangeListener getForwardingValueChangeListener() {
        if (this.forwardingValueChangeListener == null) {
            this.forwardingValueChangeListener = new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    MyValueChangeEvent myEvent = new MyValueChangeEvent(event.diff);
                    DelegatingObservableValue.this.fireEvent((ObservableEvent)myEvent);
                }
            };
        }
        return this.forwardingValueChangeListener;
    }

    class MyValueChangeEvent
    extends ValueChangeEvent {
        private static final long serialVersionUID = 1L;

        MyValueChangeEvent(ValueDiff diff) {
            super((IObservableValue)DelegatingObservableValue.this.getRealObservable(), diff);
        }

        protected Object getListenerType() {
            return VALUE_EVENT_TYPE;
        }
    }
}

