/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.tools.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseCommandUtils {
    public static final String TOGGLE_STATE = "org.eclipse.ui.commands.toggleState";
    public static final String RADIO_STATE = "org.eclipse.ui.commands.radioState";
    public static final String DELETE_COMMAND = "org.eclipse.ui.edit.delete";

    private EclipseCommandUtils() {
    }

    public static final Collection<Command> getAllExistingCommandsInCategory(String categoryId) {
        TreeSet<Command> commands = new TreeSet<Command>();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Category category = commandService.getCategory(categoryId);
        Command[] commandArray = commandService.getDefinedCommands();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Command command = commandArray[n2];
                Category currentCategory = null;
                try {
                    currentCategory = command.getCategory();
                }
                catch (NotDefinedException e) {
                    Activator.log.debug(e.getLocalizedMessage());
                    break block4;
                }
                if (category.equals((Object)currentCategory)) {
                    commands.add(command);
                }
            }
            ++n2;
        }
        return commands;
    }

    public static final ImageDescriptor getCommandIcon(Command command) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandImageService service = (ICommandImageService)workbench.getService(ICommandImageService.class);
        ImageDescriptor imageDescriptor = service.getImageDescriptor(command.getId());
        return imageDescriptor;
    }

    public static final void updateToggleCommandState(Command command, boolean newValue) {
        State state;
        if (command != null && (state = command.getState(TOGGLE_STATE)) != null) {
            state.setValue((Object)newValue);
        }
    }

    public static final void updateRadioCommandState(Command command, Object newValue) {
        State state;
        if (command != null && (state = command.getState(RADIO_STATE)) != null) {
            state.setValue(newValue);
        }
    }

    public static final ICommandService getCommandService() {
        IWorkbenchWindow ww;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (ww = wb.getActiveWorkbenchWindow()) != null) {
            return (ICommandService)ww.getService(ICommandService.class);
        }
        return null;
    }
}

