/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    private TypeUtils() {
    }

    public static final boolean isBooleanValue(String str) {
        return "true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str);
    }

    public static final boolean isIntegerValue(String str) {
        Pattern digit = Pattern.compile("-?\\d+");
        boolean result = false;
        Matcher matcher = digit.matcher(str);
        if (matcher != null) {
            result = matcher.matches();
        }
        return result;
    }

    public static final boolean isDoubleValue(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final boolean isNaturalValue(String str) {
        boolean res = TypeUtils.isIntegerValue(str);
        if (res) {
            int tmp = Integer.parseInt(str);
            return tmp >= 0;
        }
        return res;
    }

    public static final boolean isNumericValue(Object object) {
        if (object instanceof String) {
            try {
                new BigDecimal((String)object);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return object instanceof Integer || object instanceof Double || object instanceof Float;
    }

    public static <T> T as(Object object, Class<T> type) {
        T result = null;
        if (type.isInstance(object)) {
            result = type.cast(object);
        }
        return result;
    }

    public static <T> T as(Object object, T default_) {
        Object result = default_;
        if (default_.getClass().isInstance(object)) {
            result = object;
        }
        return result;
    }

    public static <T> T as(Object[] array, int index, Class<T> type) {
        Object object = index >= 0 && index < array.length ? array[index] : null;
        T result = null;
        if (type.isInstance(object)) {
            result = type.cast(object);
        }
        return result;
    }
}

