/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.databinding.CLabelObservableValue;
import org.eclipse.papyrus.infra.widgets.databinding.ReferenceDialogObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.ITreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ReferenceDialog
extends AbstractReferenceDialog
implements SelectionListener {
    protected final CLabel currentValueLabel;
    protected Button browseValuesButton;
    protected Button createInstanceButton;
    protected Button editInstanceButton;
    protected Button unsetButton;
    protected ILabelProvider labelProvider;
    protected IStaticContentProvider contentProvider;
    protected final ITreeSelectorDialog dialog;
    protected Object value;
    protected ReferenceValueFactory valueFactory;
    protected boolean readOnly;
    private boolean directCreation;
    protected boolean mandatory;
    private ControlDecoration controlDecoration;
    protected boolean error = false;
    private Timer timer;
    private TimerTask changeColorTask;
    private boolean edit = false;

    public ReferenceDialog(Composite parent, int style) {
        super(parent, style);
        GridData gridData = this.getDefaultLayoutData();
        this.currentValueLabel = factory.createCLabel((Composite)this, null, factory.getBorderStyle() | style);
        this.currentValueLabel.setLayoutData((Object)gridData);
        this.currentValueLabel.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ReferenceDialog.this.editAction();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.dialog = this.createDialog(parent.getShell());
        this.createButtons();
        this.updateControls();
        this.controlDecoration = new ControlDecoration((Control)this.currentValueLabel, 16512);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
    }

    protected ITreeSelectorDialog createDialog(Shell shell) {
        return new TreeSelectorDialog(shell);
    }

    protected void createButtons() {
        ((GridLayout)this.getLayout()).numColumns += 4;
        this.browseValuesButton = factory.createButton((Composite)this, null, 8);
        this.browseValuesButton.setImage(Activator.getDefault().getImage("/icons/browse_12x12.gif"));
        this.browseValuesButton.setToolTipText(Messages.ReferenceDialog_EditValue);
        this.browseValuesButton.addSelectionListener((SelectionListener)this);
        this.createInstanceButton = factory.createButton((Composite)this, null, 8);
        this.createInstanceButton.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.createInstanceButton.setToolTipText(Messages.ReferenceDialog_CreateANewObject);
        this.createInstanceButton.addSelectionListener((SelectionListener)this);
        this.editInstanceButton = factory.createButton((Composite)this, null, 8);
        this.editInstanceButton.setImage(Activator.getDefault().getImage("/icons/Edit_12x12.gif"));
        this.editInstanceButton.setToolTipText(Messages.ReferenceDialog_EditTheCurrentValue);
        this.editInstanceButton.addSelectionListener((SelectionListener)this);
        this.unsetButton = factory.createButton((Composite)this, null, 8);
        this.unsetButton.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.unsetButton.setToolTipText(Messages.ReferenceDialog_UnsetValue);
        this.unsetButton.addSelectionListener((SelectionListener)this);
    }

    protected void browseAction() {
        this.setInitialSelection(Collections.singletonList(this.getValue()));
        int result = this.dialog.open();
        if (result == 0) {
            Object[] newValue = this.dialog.getResult();
            if (newValue == null) {
                return;
            }
            if (newValue.length == 0) {
                this.setValue(null);
            } else {
                Object value = newValue[0];
                if (this.contentProvider instanceof IAdaptableContentProvider) {
                    value = ((IAdaptableContentProvider)((Object)this.contentProvider)).getAdaptedValue(value);
                }
                this.setValue(value);
            }
        }
    }

    protected void createAction() {
        if (this.valueFactory != null && this.valueFactory.canCreateObject()) {
            final Object context = this.getContextElement();
            this.getOperationExecutor(context).execute(new Runnable(){

                @Override
                public void run() {
                    Object value = ReferenceDialog.this.valueFactory.createObject((Control)ReferenceDialog.this.createInstanceButton, context);
                    if (value == null) {
                        throw new OperationCanceledException();
                    }
                    Collection<Object> validatedObjects = ReferenceDialog.this.valueFactory.validateObjects(Collections.singleton(value));
                    if (!validatedObjects.isEmpty()) {
                        ReferenceDialog.this.setValue(validatedObjects.iterator().next());
                    }
                }
            }, NLS.bind((String)Messages.ReferenceDialog_setOperation, (Object)this.labelText));
        }
    }

    protected void editAction() {
        this.currentValueLabel.setBackground(EDIT);
        this.edit = true;
        final Object currentValue = this.getValue();
        if (currentValue != null && this.valueFactory != null && this.valueFactory.canEdit()) {
            this.getOperationExecutor(currentValue).execute(new Runnable(){

                @Override
                public void run() {
                    Object newValue = ReferenceDialog.this.valueFactory.edit((Control)ReferenceDialog.this.editInstanceButton, currentValue);
                    if (newValue != null && newValue != currentValue) {
                        ReferenceDialog.this.setValue(newValue);
                    }
                    ReferenceDialog.this.updateLabel();
                }
            }, NLS.bind((String)Messages.ReferenceDialog_editOperation, (Object)this.labelText));
        }
    }

    protected void unsetAction() {
        this.setValue(null);
    }

    @Override
    public void updateLabel() {
        if (this.binding != null) {
            this.binding.updateModelToTarget();
        } else if (this.labelProvider != null) {
            this.currentValueLabel.setImage(this.labelProvider.getImage(this.getValue()));
            this.currentValueLabel.setText(this.labelProvider.getText(this.getValue()));
        }
    }

    @Override
    public void setContentProvider(IStaticContentProvider provider) {
        this.dialog.setContentProvider(new EncapsulatedContentProvider(provider));
        if (this.getValue() != null) {
            this.setInitialSelection(Collections.singletonList(this.getValue()));
        }
        this.contentProvider = provider;
    }

    @Override
    public void setLabelProvider(ILabelProvider provider) {
        if (provider == null) {
            this.setLabelProvider((ILabelProvider)new LabelProvider());
            return;
        }
        this.dialog.setLabelProvider(provider);
        this.labelProvider = provider;
        if (this.widgetObservable != null) {
            ((CLabelObservableValue)this.widgetObservable).setLabelProvider(this.labelProvider);
        }
        this.updateLabel();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
        this.dialog.setTitle(label);
    }

    @Override
    public Object getValue() {
        if (this.modelProperty != null) {
            return this.modelProperty.getValue();
        }
        return this.value;
    }

    @Override
    public Object getEditableType() {
        return Object.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateControls();
    }

    @Override
    public boolean isReadOnly() {
        return !this.currentValueLabel.isEnabled();
    }

    @Override
    protected void doBinding() {
        super.doBinding();
    }

    protected void setInitialSelection(List<?> initialValues) {
        this.dialog.setInitialElementSelections(initialValues);
    }

    @Override
    public void setModelObservable(IObservableValue modelProperty) {
        this.setWidgetObservable(this.createWidgetObservable(modelProperty));
        super.setModelObservable(modelProperty);
        this.updateControls();
    }

    protected IObservableValue createWidgetObservable(IObservableValue modelProperty) {
        return new ReferenceDialogObservableValue(this, this.currentValueLabel, modelProperty, this.labelProvider);
    }

    public void setToolTipText(String text) {
        super.setLabelToolTipText(text);
        this.currentValueLabel.setToolTipText(text);
    }

    @Override
    public void setValueFactory(ReferenceValueFactory factory) {
        this.valueFactory = factory;
        this.updateControls();
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget == this.browseValuesButton) {
            this.browseAction();
        } else if (widget == this.createInstanceButton) {
            this.createAction();
        } else if (widget == this.editInstanceButton) {
            this.editAction();
        } else if (widget == this.unsetButton) {
            this.unsetAction();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void updateControls() {
        boolean exclude = this.valueFactory == null || !this.valueFactory.canCreateObject();
        this.setExclusion((Control)this.editInstanceButton, exclude);
        this.setExclusion((Control)this.createInstanceButton, exclude);
        this.setExclusion((Control)this.browseValuesButton, this.directCreation);
        this.browseValuesButton.setEnabled(!this.readOnly);
        if (!exclude) {
            this.editInstanceButton.setEnabled(this.valueFactory != null && this.valueFactory.canEdit() && this.getValue() != null);
            this.createInstanceButton.setEnabled(this.valueFactory != null && this.valueFactory.canCreateObject() && !this.readOnly);
        }
        this.setExclusion((Control)this.unsetButton, this.mandatory);
        if (!this.mandatory) {
            boolean enabled = !this.readOnly;
            enabled = enabled && this.getValue() != null;
            this.unsetButton.setEnabled(enabled);
        }
    }

    public void update() {
        super.update();
        this.updateControls();
    }

    @Override
    public void setDirectCreation(boolean directCreation) {
        this.directCreation = directCreation;
        this.updateControls();
    }

    public void setValue(Object value) {
        this.value = value;
        try {
            if (this.modelProperty != null) {
                this.modelProperty.setValue(value);
                this.error = false;
            }
        }
        catch (Exception e) {
            this.error = true;
        }
        this.updateControls();
        this.updateLabel();
        this.commit();
    }

    public void setInput(Object input) {
        this.dialog.setInput(input);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public void updateStatus(IStatus status) {
        if (this.error) {
            FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.controlDecoration.setImage(error.getImage());
            this.controlDecoration.showHoverText(Messages.ReferenceDialog_0);
            this.controlDecoration.setDescriptionText(Messages.ReferenceDialog_1);
            this.controlDecoration.show();
            this.currentValueLabel.setBackground(ERROR);
            this.currentValueLabel.update();
        } else {
            this.controlDecoration.hide();
        }
    }

    public void dispose() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.dispose();
    }

    private void cancelCurrentTask() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
        }
    }

    @Override
    public void changeColorField() {
        if (!this.error & !this.edit) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelCurrentTask();
            this.changeColorTask = new TimerTask(){

                @Override
                public void run() {
                    if (ReferenceDialog.this.isDisposed()) {
                        return;
                    }
                    ReferenceDialog.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ReferenceDialog.this.isDisposed()) {
                                return;
                            }
                            (this).ReferenceDialog.this.currentValueLabel.setBackground(DEFAULT);
                            (this).ReferenceDialog.this.currentValueLabel.update();
                        }
                    });
                }
            };
            if (this.errorBinding) {
                this.currentValueLabel.setBackground(ERROR);
                this.currentValueLabel.update();
            } else {
                IStatus status = (IStatus)this.binding.getValidationStatus().getValue();
                switch (status.getSeverity()) {
                    case 0: 
                    case 2: {
                        this.timer.schedule(this.changeColorTask, 600L);
                        this.currentValueLabel.setBackground(VALID);
                        this.currentValueLabel.update();
                        break;
                    }
                    case 4: {
                        this.currentValueLabel.setBackground(ERROR);
                        this.currentValueLabel.update();
                    }
                }
            }
        } else {
            this.currentValueLabel.setBackground(DEFAULT);
        }
    }
}

