/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.commands;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.PackageRefactoringContext;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.statushandlers.StatusManager;

class SaveModelCommand
extends AbstractCommand {
    private final ModelSet modelSet;
    private volatile boolean savePending;

    SaveModelCommand(PackageRefactoringContext context) {
        super(Messages.SaveModelCommand_0);
        this.modelSet = (ModelSet)context.getEditingDomain().getResourceSet();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.savePending) {
            this.savePending = false;
            return CommandResult.newOKCommandResult();
        }
        this.savePending = true;
        Activator.getDefault().getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (!SaveModelCommand.this.savePending) {
                    return;
                }
                SaveModelCommand.this.savePending = false;
                try {
                    IRunnableWithProgress save = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                IEditorPart editor = SaveModelCommand.findEditor(SaveModelCommand.this.modelSet);
                                if (editor != null) {
                                    SaveModelCommand.save(editor);
                                } else {
                                    SaveModelCommand.this.modelSet.save(monitor);
                                }
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    if (Display.getCurrent() != null) {
                        Activator.getActiveWorkbenchWindow().run(false, false, save);
                    } else {
                        save.run((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (InvocationTargetException e) {
                    Status status = new Status(2, "org.eclipse.papyrus.uml.decoratormodel.controlmode", Messages.SaveModelCommand_1, e.getTargetException());
                    StatusManager.getManager().handle((IStatus)status, 3);
                }
                catch (InterruptedException e) {
                    Status status = new Status(2, "org.eclipse.papyrus.uml.decoratormodel.controlmode", Messages.SaveModelCommand_2, (Throwable)e);
                    StatusManager.getManager().handle((IStatus)status, 3);
                }
            }
        });
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    static IEditorPart findEditor(ModelSet modelSet) {
        IMultiDiagramEditor result = null;
        try {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)ServiceUtilsForResourceSet.getInstance().getService(IMultiDiagramEditor.class, (Object)modelSet);
            if (editor instanceof IEditorPart) {
                result = editor;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    static void save(IEditorPart editor) {
        editor.getSite().getPage().saveEditor(editor, false);
    }
}

