/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.properties.widgets;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.uml.decoratormodel.internal.properties.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.commands.UnloadDecoratorModelHandler;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers.DecoratorModelLabelProvider;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.DuplicateDecoratorModelWizard;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.LoadProfileApplicationsWizard;
import org.eclipse.papyrus.uml.decoratormodel.properties.Activator;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class DecoratorModelPropertyEditor
extends AbstractPropertyEditor {
    public DecoratorModelPropertyEditor(Composite parent, int style) {
        super((AbstractListEditor)new DecoratorModelEditor(parent, style));
    }

    static class DecoratorModelEditor
    extends AbstractListEditor
    implements IChangeListener {
        private TableViewer table;
        private Button loadButton;
        private Button unloadButton;
        private Button duplicateButton;
        private boolean preservingSelection;

        protected DecoratorModelEditor(Composite parent, int style) {
            super(parent, style, Messages.DecoratorModelPropertyEditor_0);
            this.setLayout((Layout)new GridLayout(2, false));
            this.createActionButtons((Composite)this);
            this.table = new TableViewer((Composite)this, 68354);
            GridData gd = new GridData(1808);
            gd.minimumHeight = 140;
            gd.horizontalSpan = 2;
            this.table.getTable().setLayoutData((Object)gd);
            TableLayout tableLayout = new TableLayout(true);
            this.table.getTable().setLayout((Layout)tableLayout);
            this.table.getTable().setHeaderVisible(true);
            this.table.getTable().setLinesVisible(true);
            this.table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            TableViewerColumn stateColumn = new TableViewerColumn(this.table, 0);
            stateColumn.getColumn().setText(Messages.DecoratorModelPropertyEditor_1);
            stateColumn.setLabelProvider((CellLabelProvider)new StateCellLabelProvider());
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 100, true));
            TableViewerColumn resourceColumn = new TableViewerColumn(this.table, 0);
            resourceColumn.getColumn().setText(Messages.DecoratorModelPropertyEditor_2);
            resourceColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DecoratorModelLabelProvider()));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(75, 350, true));
            this.table.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DecoratorModelEditor.this.updateButtons();
                }
            });
            this.table.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (DecoratorModelEditor.this.loadButton.isEnabled()) {
                        DecoratorModelEditor.this.loadDecoratorModels();
                    }
                }
            });
            this.updateButtons();
        }

        protected GridData getLabelLayoutData() {
            GridData result = super.getLabelLayoutData();
            result.horizontalAlignment = 4;
            result.grabExcessHorizontalSpace = true;
            return result;
        }

        protected void createActionButtons(Composite parent) {
            Composite buttonsArea = new Composite(parent, 0);
            buttonsArea.setLayoutData((Object)new GridData(0x1000008, -1, false, false));
            buttonsArea.setLayout((Layout)new RowLayout());
            this.loadButton = new Button(buttonsArea, 8);
            this.loadButton.setImage(Activator.getDefault().getImage("/icons/full/dtool16/load_resource.png"));
            this.loadButton.setToolTipText(Messages.DecoratorModelPropertyEditor_3);
            this.unloadButton = new Button(buttonsArea, 8);
            this.unloadButton.setImage(Activator.getDefault().getImage("/icons/full/ctool16/unload_resource.png"));
            this.unloadButton.setToolTipText(Messages.DecoratorModelPropertyEditor_4);
            this.duplicateButton = new Button(buttonsArea, 8);
            this.duplicateButton.setImage(Activator.getDefault().getImage("/icons/full/ctool16/dup_resource.png"));
            this.duplicateButton.setToolTipText(Messages.DecoratorModelPropertyEditor_5);
            SelectionAdapter action = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DecoratorModelEditor.this.action((Button)e.widget);
                }
            };
            this.loadButton.addSelectionListener((SelectionListener)action);
            this.unloadButton.addSelectionListener((SelectionListener)action);
            this.duplicateButton.addSelectionListener((SelectionListener)action);
        }

        protected void action(Button button) {
            if (button == this.loadButton) {
                this.loadDecoratorModels();
            } else if (button == this.unloadButton) {
                this.unloadDecoratorModels();
            } else if (button == this.duplicateButton) {
                this.duplicateDecoratorModel();
            }
            this.updateButtons();
        }

        protected void doBinding() {
            super.doBinding();
            this.table.setInput((Object)this.modelProperty);
            this.modelProperty.addChangeListener((IChangeListener)this);
        }

        public void handleChange(ChangeEvent event) {
            if (!this.isDisposed()) {
                this.preservingSelection(new Runnable(){

                    public void run() {
                        DecoratorModelEditor.this.table.refresh();
                    }
                });
            }
        }

        protected Package getPackage() {
            return (Package)this.getContextElement();
        }

        protected void loadDecoratorModels() {
            ImmutableSet resources = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)((IStructuredSelection)this.table.getSelection()).toList(), URI.class));
            if (!Iterables.isEmpty((Iterable)resources)) {
                final LoadProfileApplicationsWizard wizard = new LoadProfileApplicationsWizard(false, true);
                wizard.init(this.getPackage(), (Iterable)resources);
                this.preservingSelection(new Runnable(){

                    public void run() {
                        if (wizard.isComplete()) {
                            wizard.performFinish();
                        } else {
                            new WizardDialog(DecoratorModelEditor.this.getShell(), (IWizard)wizard).open();
                        }
                    }
                });
            }
        }

        protected void unloadDecoratorModels() {
            final Iterable resources = Iterables.filter((Iterable)((IStructuredSelection)this.table.getSelection()).toList(), Resource.class);
            if (!Iterables.isEmpty((Iterable)resources)) {
                final ResourceSet rset = ((Resource)Iterables.getFirst((Iterable)resources, null)).getResourceSet();
                this.preservingSelection(new Runnable(){

                    public void run() {
                        try {
                            UnloadDecoratorModelHandler.unloadResources((IWorkbenchWindow)Activator.getActiveWorkbenchWindow(), (ResourceSet)rset, (Iterable)resources);
                        }
                        catch (ExecutionException e) {
                            Throwable exc = e.getCause() != null ? e.getCause() : e;
                            Status status = new Status(4, "org.eclipse.papyrus.uml.decoratormodel.properties", Messages.DecoratorModelPropertyEditor_6, exc);
                            Activator.getDefault().getLog().log((IStatus)status);
                            StatusManager.getManager().handle((IStatus)status, 2);
                        }
                    }
                });
            }
        }

        protected void duplicateDecoratorModel() {
            final Object selected = ((IStructuredSelection)this.table.getSelection()).getFirstElement();
            if (selected != null) {
                this.preservingSelection(new Runnable(){

                    public void run() {
                        DuplicateDecoratorModelWizard wizard = new DuplicateDecoratorModelWizard();
                        wizard.init(EMFHelper.getResourceSet((EObject)DecoratorModelEditor.this.getPackage()), selected);
                        new WizardDialog(DecoratorModelEditor.this.getShell(), (IWizard)wizard).open();
                    }
                });
            }
        }

        protected void updateButtons() {
            boolean enableDup;
            boolean enableLoad;
            List selection = ((IStructuredSelection)this.table.getSelection()).toList();
            boolean enableUnload = enableLoad = !selection.isEmpty();
            boolean bl = enableDup = selection.size() == 1;
            if (enableLoad) {
                for (Object next : selection) {
                    enableLoad = enableLoad && !(next instanceof Resource);
                    boolean bl2 = enableUnload = enableUnload && next instanceof Resource;
                }
            }
            this.loadButton.setImage(Activator.getDefault().getImage(enableLoad ? "/icons/full/etool16/load_resource.png" : "/icons/full/dtool16/load_resource.png"));
            this.loadButton.setEnabled(enableLoad);
            this.unloadButton.setEnabled(enableUnload);
            this.duplicateButton.setEnabled(enableDup);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        void preservingSelection(Runnable runnable) {
            block7: {
                wasPreservingSelection = this.preservingSelection;
                selection = null;
                uris = null;
                if (!this.preservingSelection) {
                    selection = Lists.newArrayList((Iterator)((IStructuredSelection)this.table.getSelection()).iterator());
                    uris = Sets.newHashSet();
                    for (E next : selection) {
                        if (next /* !! */  instanceof Resource) {
                            next /* !! */  = ((Resource)next /* !! */ ).getURI();
                        }
                        if (!(next /* !! */  instanceof URI)) continue;
                        uris.add((URI)next /* !! */ );
                    }
                    this.preservingSelection = true;
                }
                try {
                    runnable.run();
                }
                finally {
                    this.preservingSelection = wasPreservingSelection;
                    if (selection == null) break block7;
                    selection.clear();
                    ** for (next : this.modelProperty)
                }
lbl-1000:
                // 1 sources

                {
                    v0 /* !! */  = next instanceof Resource != false ? ((Resource)next).getURI() : (uri = next instanceof URI != false ? (URI)next : null);
                    if (!uris.contains(uri)) continue;
                    selection.add(next);
                    continue;
                }
lbl28:
                // 1 sources

                this.table.setSelection((ISelection)new StructuredSelection((List)selection), true);
                this.updateButtons();
            }
        }

        public Object getEditableType() {
            return List.class;
        }

        public void setReadOnly(boolean readOnly) {
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    static class StateCellLabelProvider
    extends CellLabelProvider {
        StateCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText(cell.getElement() instanceof Resource ? Messages.DecoratorModelPropertyEditor_7 : Messages.DecoratorModelPropertyEditor_8);
        }
    }
}

