/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.tools.util.ICallableWithProgress;
import org.eclipse.papyrus.infra.tools.util.UIUtil;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelCopier;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.DuplicateDecoratorModelPage;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.UnloadProfileApplicationsWizard;
import org.eclipse.ui.statushandlers.StatusManager;

public class DuplicateDecoratorModelWizard
extends Wizard {
    private ResourceSet resourceSet;
    private Object decoratorModel;
    private DuplicateDecoratorModelPage mainPage;

    public DuplicateDecoratorModelWizard() {
        this.setWindowTitle(Messages.DuplicateDecoratorModelWizard_0);
        this.setDialogSettings(DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getSimpleName()));
    }

    public void init(ResourceSet resourceSet, Object decoratorModel) {
        this.resourceSet = resourceSet;
        this.decoratorModel = decoratorModel;
        if (this.mainPage != null) {
            this.mainPage.setInput(decoratorModel);
        }
    }

    public void addPages() {
        this.mainPage = new DuplicateDecoratorModelPage(this.resourceSet);
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.setInput(this.decoratorModel);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        boolean result = false;
        this.mainPage.saveSettings();
        ImmutableSet profileURIs = ImmutableSet.copyOf((Collection)this.mainPage.getSelectedProfileApplications());
        final URI resourceURI = this.mainPage.getResourceURI();
        final String modelName = this.mainPage.getModelName();
        if (!profileURIs.isEmpty() && resourceURI != null) {
            try {
                result = (Boolean)UIUtil.call((IRunnableContext)this.getContainer(), (boolean)false, (boolean)false, (ICallableWithProgress)new ICallableWithProgress<Boolean>((Set)profileURIs){
                    private final /* synthetic */ Set val$profileURIs;
                    {
                        this.val$profileURIs = set;
                    }

                    public Boolean call(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        boolean result = false;
                        monitor.beginTask(Messages.DuplicateDecoratorModelWizard_1, -1);
                        try {
                            URI decoratorModelURI;
                            ResourceSet resourceSet;
                            if (DuplicateDecoratorModelWizard.this.decoratorModel instanceof Resource) {
                                Resource unload = (Resource)DuplicateDecoratorModelWizard.this.decoratorModel;
                                resourceSet = unload.getResourceSet();
                                decoratorModelURI = unload.getURI();
                                if (!UnloadProfileApplicationsWizard.unload(resourceSet, Collections.singleton(unload.getURI()))) {
                                    Boolean bl = false;
                                    return bl;
                                }
                            } else {
                                resourceSet = null;
                                decoratorModelURI = (URI)DuplicateDecoratorModelWizard.this.decoratorModel;
                            }
                            try {
                                result = DuplicateDecoratorModelWizard.this.copy(decoratorModelURI, resourceURI, modelName, this.val$profileURIs);
                                if (result && resourceSet != null) {
                                    DecoratorModelUtils.loadDecoratorModels((ResourceSet)resourceSet, Collections.singleton(resourceURI));
                                }
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return result;
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.eclipse.papyrus.uml.decoratormodel.ui", Messages.DuplicateDecoratorModelWizard_2, e.getTargetException());
                StatusManager.getManager().handle((IStatus)status, 3);
            }
        }
        return result;
    }

    private boolean copy(URI sourceModel, URI destinationModel, String modelName, Set<URI> profileURIs) throws IOException {
        boolean result = false;
        DecoratorModelCopier copier = new DecoratorModelCopier(modelName, profileURIs);
        try {
            Resource destination = copier.copy(sourceModel, destinationModel);
            destination.save(null);
            result = true;
        }
        finally {
            copier.dispose();
        }
        return result;
    }
}

