/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.helper;

import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.command.CustomDropAppliedStereotypeCommand;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ClassEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ModelEditPartCN;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ModelEditPartTN;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.NestedClassForClassEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.PackageEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.PackageEditPartCN;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Stereotype;

public class ContainmentHelper
extends ElementHelper {
    protected static final String CREATE_CONTAINMENT = "Create Containment";
    public static final String CONTAINMENT_CIRCLE_POSITION = "ContainmentCirclePosition";
    public static final String KEY_CONNECTION_VIEW = "connection_view";

    public ContainmentHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public void deleteIncomingContainmentLinksFor(CompositeCommand cc, View node) {
        for (Object incomingLink : node.getTargetEdges()) {
            Edge nextConnector = (Edge)incomingLink;
            View nextConnectorSource = nextConnector.getSource();
            if (!ContainmentHelper.isContainmentLink(nextConnector)) continue;
            cc.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)nextConnector));
            if (!ContainmentHelper.isContainmentCircle(nextConnectorSource) || nextConnectorSource.getSourceEdges().size() != 1) continue;
            cc.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), nextConnectorSource));
        }
    }

    public void deleteOutgoingContainmentLinksFor(CompositeCommand cc, View node) {
        for (Object nextChild : node.getVisibleChildren()) {
            View circle = (View)nextChild;
            if (!ContainmentHelper.isContainmentCircle(circle)) continue;
            for (Object next : circle.getSourceEdges()) {
                Edge outgoingLink = (Edge)next;
                if (!ContainmentHelper.isContainmentLink(outgoingLink)) continue;
                cc.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)outgoingLink));
            }
        }
    }

    public Command outlineDropContainedClass(PackageableElement droppedElement, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView) {
        return this.dropElementToDiagram(droppedElement, viewer, diagramPreferencesHint, location, containerView);
    }

    public Command dropElementToDiagram(PackageableElement droppedElement, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView) {
        GraphicalEditPart parentEP;
        EditPart droppedElementEditPart = this.findEditPartFor(viewer.getEditPartRegistry(), (Element)droppedElement);
        Element owner = droppedElement.getOwner();
        GraphicalEditPart containerEditpart = null;
        if (droppedElementEditPart != null && (parentEP = (GraphicalEditPart)droppedElementEditPart.getParent()).resolveSemanticElement().equals(owner)) {
            containerEditpart = parentEP;
        }
        CompositeCommand cc = new CompositeCommand("drop");
        if (containerEditpart == null) {
            this.dropElementToDiagram(cc, droppedElement, diagramPreferencesHint, location, containerView);
        } else if (this.canHaveContainmentLink(droppedElementEditPart)) {
            cc.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), (View)droppedElementEditPart.getModel()));
            this.dropElementToDiagram(cc, droppedElement, diagramPreferencesHint, location, containerView);
        }
        return new ICommandProxy((ICommand)cc);
    }

    protected void dropElementToDiagram(CompositeCommand cc, PackageableElement droppedElement, PreferencesHint diagramPreferencesHint, Point location, View containerView) {
        CreateViewRequest.ViewDescriptor droppedElementDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)droppedElement), Node.class, null, -1, true, diagramPreferencesHint);
        CreateCommand containedNodeCreationCommand = new CreateCommand(this.editDomain, droppedElementDescriptor, containerView);
        cc.add((IUndoableOperation)containedNodeCreationCommand);
        cc.add((IUndoableOperation)new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)containedNodeCreationCommand.getCommandResult().getReturnValue(), new Point(location.x, location.y - 100)));
        this.addStereotypeLabelToDroppedElement(cc, droppedElement, (IAdaptable)containedNodeCreationCommand.getCommandResult().getReturnValue());
    }

    protected void addStereotypeLabelToDroppedElement(CompositeCommand cc, PackageableElement droppedElement, IAdaptable createdEditPartAdapter) {
        if (droppedElement.getAppliedStereotypes().isEmpty()) {
            return;
        }
        EList stereotypeAppliedList = droppedElement.getAppliedStereotypes();
        for (Stereotype stereotype : stereotypeAppliedList) {
            String profileApplied = "\"" + stereotype.getProfile() + "\"::";
            cc.add((IUndoableOperation)new CustomDropAppliedStereotypeCommand(this.editDomain, createdEditPartAdapter, profileApplied, "Compartment"));
        }
    }

    public static boolean isReorientContainmentLink(ReconnectRequest request) {
        int visualId = ContainmentHelper.getVisualID(request);
        return visualId == 4023;
    }

    public static ReconnectRequest extendReorientTargetRequest(ReconnectRequest request) {
        Object view = request.getConnectionEditPart().getModel();
        if (view instanceof View) {
            request.getExtendedData().put(KEY_CONNECTION_VIEW, view);
        }
        return request;
    }

    public static ReconnectRequest extendReorientSourceRequest(ReconnectRequest request) {
        Object view = request.getConnectionEditPart().getModel();
        if (view instanceof View) {
            request.getExtendedData().put(KEY_CONNECTION_VIEW, view);
        }
        return request;
    }

    private static int getVisualID(ReconnectRequest request) {
        Object id = request.getExtendedData().get("visual_id");
        return id instanceof Integer ? (Integer)id : -1;
    }

    public static boolean isContainmentLink(Edge edge) {
        return UMLVisualIDRegistry.getVisualID((View)edge) == 4023;
    }

    public static boolean isContainmentCircle(View view) {
        return false;
    }

    private static boolean circleHasOtherLinks(View containmentCircle) {
        return containmentCircle.getSourceEdges().size() > 1;
    }

    public static IUndoableOperation deleteIncomingContainmentLinkCommand(TransactionalEditingDomain editingDomain, Edge incomingLink) {
        CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(editingDomain, "Delete Incoming Containment Link");
        cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)incomingLink));
        View containmentCircle = incomingLink.getSource();
        if (!ContainmentHelper.circleHasOtherLinks(containmentCircle)) {
            cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, containmentCircle));
        }
        return cmd;
    }

    public static void addDeleteIncomingContainmentLinkViewCommands(TransactionalEditingDomain editingDomain, View targetNode, ICompositeCommand cmd) {
        for (Object next : targetNode.getTargetEdges()) {
            Edge incomingLink = (Edge)next;
            if (!ContainmentHelper.isContainmentLink(incomingLink)) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)incomingLink));
            View containmentCircle = incomingLink.getSource();
            if (ContainmentHelper.circleHasOtherLinks(containmentCircle)) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, containmentCircle));
        }
    }

    public static boolean hasIncomingContainmentLink(View targetNode) {
        for (Object next : targetNode.getTargetEdges()) {
            Edge incomingLink = (Edge)next;
            if (!ContainmentHelper.isContainmentLink(incomingLink)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOutgoingContainmentLink(View targetNode) {
        for (Object next : targetNode.getVisibleChildren()) {
            View node = (View)next;
            if (!ContainmentHelper.isContainmentCircle(node)) continue;
            for (Object nextLink : node.getSourceEdges()) {
                Edge outgoingLink = (Edge)nextLink;
                if (!ContainmentHelper.isContainmentLink(outgoingLink)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addDeleteOutgoingContainmentLinkViewCommands(TransactionalEditingDomain editingDomain, View sourceNode, ICompositeCommand cmd) {
        for (Object child : sourceNode.getVisibleChildren()) {
            if (!ContainmentHelper.isContainmentCircle((View)child)) continue;
            View circle = (View)child;
            cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, circle));
            for (Object next : circle.getSourceEdges()) {
                Edge outgoingLink = (Edge)next;
                if (!ContainmentHelper.isContainmentLink(outgoingLink)) continue;
                cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, (View)outgoingLink));
                cmd.add((IUndoableOperation)new DeleteCommand(editingDomain, outgoingLink.getTarget()));
                ContainmentHelper.addDeleteOutgoingContainmentLinkViewCommands(editingDomain, outgoingLink.getTarget(), cmd);
            }
        }
    }

    public EditPart findEditPartFor(Map<?, ?> editPartRegistry, Element droppedElement) {
        for (Object next : editPartRegistry.values()) {
            View currentView;
            EditPart currentEditPart = (EditPart)next;
            if (!this.canHaveContainmentLink(currentEditPart) || !droppedElement.equals((currentView = (View)currentEditPart.getModel()).getElement())) continue;
            return currentEditPart;
        }
        return null;
    }

    private boolean canHaveContainmentLink(EditPart currentEditPart) {
        return currentEditPart instanceof ClassEditPart || currentEditPart instanceof PackageEditPartCN || currentEditPart instanceof PackageEditPart || currentEditPart instanceof ModelEditPartTN || currentEditPart instanceof NestedClassForClassEditPart || currentEditPart instanceof ModelEditPartCN;
    }

    public boolean move(EObject objectToMove, EObject to) {
        if (objectToMove instanceof Package) {
            return this.movePackage((Package)objectToMove, to);
        }
        if (objectToMove instanceof Class) {
            return this.moveClass((Class)objectToMove, to);
        }
        return false;
    }

    private boolean movePackage(Package pakkage, EObject to) {
        Element from = pakkage.getOwner();
        if (to instanceof Package && from instanceof Package) {
            this.doMovePackage(pakkage, (Package)from, (Package)to);
            return true;
        }
        return false;
    }

    private boolean moveClass(Class clazz, EObject to) {
        Element from = clazz.getOwner();
        if (from instanceof Class) {
            Class fromClazz = (Class)from;
            if (to instanceof Class) {
                this.doMoveClass(clazz, fromClazz, (Class)to);
                return true;
            }
            if (to instanceof Package) {
                this.doMoveClass(clazz, fromClazz, (Package)to);
                return true;
            }
        }
        if (from instanceof Package) {
            Package fromPackage = (Package)from;
            if (to instanceof Class) {
                this.doMoveClass(clazz, fromPackage, (Class)to);
                return true;
            }
            if (to instanceof Package) {
                this.doMoveClass(clazz, fromPackage, (Package)to);
                return true;
            }
        }
        return false;
    }

    private void doMovePackage(Package pakkage, Package from, Package to) {
        from.getNestedPackages().remove((Object)pakkage);
        to.getNestedPackages().add((Object)pakkage);
    }

    private void doMoveClass(Class clazz, Package from, Package to) {
        from.getPackagedElements().remove((Object)clazz);
        to.getPackagedElements().add((Object)clazz);
    }

    private void doMoveClass(Class clazz, Package from, Class to) {
        from.getPackagedElements().remove((Object)clazz);
        to.getNestedClassifiers().add((Object)clazz);
    }

    private void doMoveClass(Class clazz, Class from, Package to) {
        from.getNestedClassifiers().remove((Object)clazz);
        to.getPackagedElements().add((Object)clazz);
    }

    private void doMoveClass(Class clazz, Class from, Class to) {
        from.getNestedClassifiers().remove((Object)clazz);
        to.getNestedClassifiers().add((Object)clazz);
    }
}

