/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.css.dom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.GMFElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.css.helper.CSSDOMUMLSemanticElementHelper;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Trigger;

public class GMFUMLElementAdapter
extends GMFElementAdapter {
    private static final String STEREOTYPE_COMMENT = "StereotypeComment";
    public final StereotypeDisplayUtil stereotypeHelper = StereotypeDisplayUtil.getInstance();
    private static final String IS_TIME_EVENT_ACTION_PROPERTY = "isTimeEventAction";
    public static final String APPLIED_STEREOTYPES_PROPERTY = "appliedStereotypes";
    public static final String QUALIFIER_SEPARATOR = "--";

    public GMFUMLElementAdapter(View view, ExtendedCSSEngine engine) {
        super(view, engine);
        this.helper = CSSDOMUMLSemanticElementHelper.getInstance();
    }

    protected String doGetAttribute(String attr) {
        String value;
        String parentValue = super.doGetAttribute(attr);
        if (parentValue != null) {
            return parentValue;
        }
        if (this.stereotypeHelper.isStereotypeLabel((Object)this.semanticElement) && (value = this.getStereotypeLabelAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if ((this.stereotypeHelper.isStereotypeCompartment((Object)this.semanticElement) || this.stereotypeHelper.isStereotypeBrace((Object)this.semanticElement)) && (value = this.getStereotypeCompartmentAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if ((this.stereotypeHelper.isStereotypeProperty((Object)this.semanticElement) || this.stereotypeHelper.isStereotypeBraceProperty((Object)this.semanticElement)) && (value = this.getStereotypePropertyAttribute(attr)) != null && !value.isEmpty()) {
            return value;
        }
        if (this.semanticElement instanceof Element) {
            Element currentElement = (Element)this.semanticElement;
            if (APPLIED_STEREOTYPES_PROPERTY.equals(attr)) {
                LinkedList<String> appliedStereotypes = new LinkedList<String>();
                for (Iterator stereotype : currentElement.getAppliedStereotypes()) {
                    appliedStereotypes.add(stereotype.getName());
                    appliedStereotypes.add(stereotype.getQualifiedName());
                }
                if (!appliedStereotypes.isEmpty()) {
                    return ListHelper.deepToString(appliedStereotypes, (String)" ");
                }
            }
            for (EObject stereotypeApplication : currentElement.getStereotypeApplications()) {
                EStructuralFeature feature = stereotypeApplication.eClass().getEStructuralFeature(attr);
                if (feature == null) continue;
                if (feature.isMany()) {
                    List values = (List)stereotypeApplication.eGet(feature);
                    LinkedList<String> cssValues = new LinkedList<String>();
                    for (Object value2 : values) {
                        cssValues.add(this.getCSSValue(feature, value2));
                    }
                    return ListHelper.deepToString(cssValues, (String)" ");
                }
                Object value3 = stereotypeApplication.eGet(feature);
                String cssValue = this.getCSSValue(feature, value3);
                return cssValue;
            }
            if (attr.contains(QUALIFIER_SEPARATOR)) {
                EObject stereotypeApplication;
                EStructuralFeature feature;
                List qualifiers = ListHelper.asList((Object[])attr.split(QUALIFIER_SEPARATOR));
                String propertyName = (String)qualifiers.remove(qualifiers.size() - 1);
                String stereotypeName = ListHelper.deepToString((List)qualifiers, (String)"::");
                Stereotype appliedStereotype = currentElement.getAppliedStereotype(stereotypeName);
                if (appliedStereotype != null && (feature = (stereotypeApplication = currentElement.getStereotypeApplication(appliedStereotype)).eClass().getEStructuralFeature(propertyName)) != null) {
                    Object value4 = stereotypeApplication.eGet(feature);
                    return this.getCSSValue(feature, value4);
                }
            }
            if (IS_TIME_EVENT_ACTION_PROPERTY.equals(attr) && this.semanticElement instanceof AcceptEventAction) {
                return String.valueOf(GMFUMLElementAdapter.isAcceptTimeEventAction((AcceptEventAction)this.semanticElement));
            }
        }
        return null;
    }

    public static boolean isAcceptTimeEventAction(AcceptEventAction action) {
        boolean hasTimeEvent = false;
        boolean hasOthersTriggers = false;
        if (action.getTriggers() != null) {
            for (Trigger trigger : action.getTriggers()) {
                if (trigger == null) continue;
                Event event = trigger.getEvent();
                if (event instanceof TimeEvent) {
                    hasTimeEvent = true;
                    continue;
                }
                hasOthersTriggers = true;
            }
        }
        return hasTimeEvent && !hasOthersTriggers;
    }

    protected String getStereotypeCompartmentAttribute(String attr) {
        if ("stereotype".equals(attr)) {
            BasicCompartment propertyCompartment = (BasicCompartment)this.semanticElement;
            return this.stereotypeHelper.getName(propertyCompartment);
        }
        return "";
    }

    protected String getStereotypePropertyAttribute(String attr) {
        EObject propertyCompartment;
        if ("property".equals(attr)) {
            DecorationNode propertyLabel = (DecorationNode)this.semanticElement;
            if (propertyLabel.getElement() instanceof Property) {
                Property prop = (Property)propertyLabel.getElement();
                String propLabel = prop.getName();
                return propLabel;
            }
        } else if ("stereotype".equals(attr) && this.stereotypeHelper.isStereotypeCompartment((Object)(propertyCompartment = ((DecorationNode)this.semanticElement).eContainer()))) {
            return this.stereotypeHelper.getName((DecorationNode)propertyCompartment);
        }
        return "";
    }

    protected String getStereotypeLabelAttribute(String attr) {
        if ("stereotype".equals(attr)) {
            DecorationNode label = (DecorationNode)this.semanticElement;
            String stereoName = this.stereotypeHelper.getName(label);
            return stereoName;
        }
        if ("kind".equals(attr) && this.stereotypeHelper.isStereotypeLabel((Object)this.semanticElement)) {
            return "StereotypeLabel";
        }
        return null;
    }

    protected String getCSSValue(EStructuralFeature feature, Object value) {
        if (feature instanceof EReference && value instanceof NamedElement) {
            String name = ((NamedElement)value).getName();
            return name == null || name.isEmpty() ? " " : name;
        }
        return super.getCSSValue(feature, value);
    }

    public String getLocalName() {
        if (this.localName == null && this.stereotypeHelper.isStereotypeComment((Object)this.getNotationElement())) {
            return STEREOTYPE_COMMENT;
        }
        return super.getLocalName();
    }
}

