/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusDiagramEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;

public class AlignActionHelper {
    private int alignment;
    private EditPart refEditPart;
    private List<IGraphicalEditPart> selectedElements;

    public AlignActionHelper() {
    }

    public AlignActionHelper(int alignment, List<IGraphicalEditPart> selectedElements) {
        this.alignment = alignment;
        this.selectedElements = selectedElements;
        this.refEditPart = this.getRefEditPart();
    }

    protected boolean isMixedSelection(List<?> editparts) {
        boolean node = false;
        boolean edge = false;
        boolean isMixed = node && edge;
        Iterator<?> iter = editparts.iterator();
        while (iter.hasNext() && !isMixed) {
            if (iter.next() instanceof AbstractConnectionEditPart) {
                edge = true;
            } else {
                node = true;
            }
            boolean bl = isMixed = node && edge;
        }
        return isMixed;
    }

    protected boolean isLinkSelection(List<IGraphicalEditPart> editparts) {
        boolean isEdgeOnly = true;
        if (editparts.size() == 0) {
            isEdgeOnly = false;
        } else {
            for (IGraphicalEditPart object : editparts) {
                if (object instanceof AbstractConnectionEditPart) continue;
                isEdgeOnly = false;
            }
        }
        return isEdgeOnly;
    }

    protected boolean isAlignAllowed(List<IGraphicalEditPart> selectedElements) {
        boolean alignAllowable = true;
        alignAllowable = alignAllowable && !this.isMixedSelection(selectedElements);
        alignAllowable = alignAllowable && selectedElements.size() >= 2;
        return alignAllowable;
    }

    protected boolean isPositionAllowed(EditPart currentEP, PrecisionRectangle newPosition) {
        boolean isAllow = true;
        isAllow = isAllow && this.isContained(newPosition, currentEP);
        isAllow = isAllow && !this.isRefChild(this.refEditPart, currentEP);
        isAllow = isAllow && this.isPortPositionAllowed(newPosition, currentEP);
        isAllow = isAllow && !this.isDependent(this.refEditPart, currentEP);
        return isAllow;
    }

    private boolean isDependent(EditPart ref, EditPart currentEP) {
        boolean isDependent = false;
        if (ref instanceof LabelEditPart && ref.getParent() instanceof AbstractConnectionEditPart) {
            EditPart source = ((ConnectionEditPart)ref.getParent()).getSource();
            EditPart target = ((ConnectionEditPart)ref.getParent()).getTarget();
            if (currentEP.equals(source) || currentEP.equals(target)) {
                isDependent = true;
            } else if (this.isRefChild(source, currentEP) || this.isRefChild(target, currentEP)) {
                isDependent = true;
            }
        }
        return isDependent;
    }

    private boolean isPortPositionAllowed(PrecisionRectangle newPosition, EditPart currentEP) {
        boolean isPortAllow;
        if (currentEP instanceof AbstractBorderItemEditPart) {
            boolean isBetweenVerticalBounds;
            PrecisionPoint portCenter = (PrecisionPoint)newPosition.getCenter();
            PrecisionRectangle parentBounds = LayoutUtils.getAbsolutePosition((EditPart)currentEP.getParent());
            boolean isOnVerticalBounds = portCenter.preciseX() == parentBounds.preciseX() || portCenter.preciseX() == parentBounds.preciseX() + parentBounds.preciseWidth();
            boolean isOnHorizontalBounds = portCenter.preciseY() == parentBounds.preciseY() || portCenter.preciseY() == parentBounds.preciseY() + parentBounds.preciseHeight();
            boolean isBetweenHorizontalBounds = portCenter.preciseY() >= parentBounds.preciseY() && portCenter.preciseY() <= parentBounds.preciseY() + parentBounds.preciseHeight();
            boolean bl = isBetweenVerticalBounds = portCenter.preciseX() >= parentBounds.preciseX() && portCenter.preciseX() <= parentBounds.preciseX() + parentBounds.preciseWidth();
            isPortAllow = isOnHorizontalBounds && isBetweenVerticalBounds ? true : isOnVerticalBounds && isBetweenHorizontalBounds;
        } else {
            isPortAllow = true;
        }
        return isPortAllow;
    }

    protected boolean isContained(PrecisionRectangle newPosition, EditPart currentEP) {
        boolean isContained = true;
        EditPart container = DiagramEditPartsUtil.getContainerEditPart((GraphicalEditPart)((GraphicalEditPart)currentEP));
        if (!(container instanceof PapyrusDiagramEditPart)) {
            PrecisionRectangle containerBounds = LayoutUtils.getAbsolutePosition((EditPart)container);
            containerBounds.expand(new Insets(-1));
            isContained = containerBounds.contains(newPosition.getBottomLeft()) && containerBounds.contains(newPosition.getTopRight());
        }
        return isContained;
    }

    protected boolean isRefChild(EditPart ref, EditPart ep) {
        boolean refIsChild = false;
        List children = ep.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext() && !refIsChild) {
            Object child = iter.next();
            if (ref.equals(child)) {
                refIsChild = true;
                continue;
            }
            if (!(child instanceof EditPart)) continue;
            refIsChild = this.isRefChild(ref, (EditPart)child);
        }
        return refIsChild;
    }

    protected EditPart getRefEditPart() {
        Iterator<IGraphicalEditPart> iter = this.selectedElements.iterator();
        EditPart ref = null;
        while (iter.hasNext() && ref == null) {
            EditPart ep = (EditPart)iter.next();
            if (ep.getSelected() != 2) continue;
            ref = ep;
        }
        return ref;
    }

    protected PrecisionRectangle getNewPosition(PrecisionRectangle currentEPBounds, PrecisionRectangle refBounds) {
        PrecisionRectangle newPosition = new PrecisionRectangle((Rectangle)currentEPBounds);
        PrecisionPoint distance = new PrecisionPoint(0.0, 0.0);
        switch (this.alignment) {
            case 1: {
                newPosition.setPreciseX(refBounds.preciseX());
                break;
            }
            case 2: {
                distance.setPreciseX(refBounds.getCenter().preciseX() - currentEPBounds.getCenter().preciseX());
                newPosition.translate((Point)distance);
                break;
            }
            case 4: {
                distance.setPreciseX(refBounds.getTopRight().preciseX() - currentEPBounds.getTopRight().preciseX());
                newPosition.translate((Point)distance);
                break;
            }
            case 8: {
                newPosition.setPreciseY(refBounds.preciseY());
                break;
            }
            case 16: {
                distance.setPreciseY(refBounds.getCenter().preciseY() - currentEPBounds.getCenter().preciseY());
                newPosition.translate((Point)distance);
                break;
            }
            case 32: {
                distance.setPreciseY(refBounds.getBottomLeft().preciseY() - currentEPBounds.getBottomLeft().preciseY());
                newPosition.translate((Point)distance);
                break;
            }
        }
        return newPosition;
    }
}

