/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpart;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ListItemComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextNonResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.parser.StereotypePropertyParser;
import org.eclipse.papyrus.uml.profile.structure.AppliedStereotypeProperty;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AppliedStereotypePropertyEditPart
extends UMLCompartmentEditPart
implements ITextAwareEditPart,
IPrimaryEditPart {
    public static final String ID = "AppliedStereotypeProperty";
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;
    static final Font THIS_FONT = new Font((Device)Display.getCurrent(), "Arial", 10, 0);

    public AppliedStereotypePropertyEditPart(View view) {
        super((EObject)view);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void activate() {
        super.activate();
        EObject stereotypeApplication = ((View)this.getNotationView().eContainer()).getElement();
        Element umlElement = UMLUtil.getBaseElement((EObject)stereotypeApplication);
        this.getDiagramEventBroker().addNotificationListener(stereotypeApplication, (NotificationListener)this);
        this.getDiagramEventBroker().addNotificationListener((EObject)umlElement, (NotificationListener)this);
    }

    public void deactivate() {
        super.deactivate();
        EObject stereotypeApplication = ((View)this.getNotationView().eContainer()).getElement();
        Element umlElement = UMLUtil.getBaseElement((EObject)stereotypeApplication);
        this.getDiagramEventBroker().removeNotificationListener(stereotypeApplication, (NotificationListener)this);
        this.getDiagramEventBroker().removeNotificationListener((EObject)umlElement, (NotificationListener)this);
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return null;
        }
        return new DragEditPartsTrackerEx((EditPart)this);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new UMLTextNonResizableEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ListItemComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        return ((Label)figure).getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setText(text);
        } else {
            ((Label)figure).setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        return ((Label)figure).getIcon();
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setIcon(icon);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        } else {
            ((Label)figure).setIcon(icon);
        }
    }

    public void setLabel(IFigure figure) {
        this.unregisterVisuals();
        this.setFigure(figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        return null;
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString((IAdaptable)new SemanticAdapter(this.resolveSemanticElement(), (Object)this.getNotationView()), this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = "SterotypeProperty";
        }
        return text;
    }

    public void setLabelText(String text) {
        EditPolicy sfEditPolicy;
        this.setLabelTextHelper(this.getFigure(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        if (!((Property)this.resolveSemanticElement()).isDerived()) {
            return this.getParser() != null;
        }
        return false;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = AppliedStereotypePropertyEditPart.this.getParserElement();
                    final IParser parser = AppliedStereotypePropertyEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)AppliedStereotypePropertyEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = new StereotypePropertyParser();
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), AppliedStereotypePropertyEditPart.getTextCellEditorLocator(this)));
        }
        return this.manager;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)source.getFigure());
        }
        return null;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                Dialog dialog = null;
                if (this.configuration instanceof IPopupEditorConfiguration) {
                    IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                    helper.showEditor();
                    return;
                }
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        AppliedStereotypePropertyEditPart.this.configuration.postEditAction((Object)AppliedStereotypePropertyEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            if (AppliedStereotypePropertyEditPart.this.isActive() && AppliedStereotypePropertyEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    AppliedStereotypePropertyEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && AppliedStereotypePropertyEditPart.this.getEditText().equals(AppliedStereotypePropertyEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    AppliedStereotypePropertyEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    AppliedStereotypePropertyEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getEditPolicy("MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
            this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject stereotypeApplication = ((View)this.getNotationView().eContainer()).getElement();
            this.addListenerFilter("SemanticModelForStereotypeApplication", (NotificationListener)this, stereotypeApplication);
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        this.removeListenerFilter("SemanticModelForStereotypeApplication");
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = AppliedStereotypePropertyEditPart.this.getLabelTextHelper(AppliedStereotypePropertyEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return (View)this.getModel();
    }

    public int getDirectEditionType() {
        if (this.checkExtendedEditor()) {
            this.initExtendedEditorConfiguration();
            return 4;
        }
        if (this.checkDefaultEdition()) {
            return 2;
        }
        return 8;
    }

    protected boolean checkExtendedEditor() {
        if (this.resolveSemanticElement() != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getParser() != null;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
            this.configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName()) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
    }

    protected void updateExtendedEditorConfiguration() {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
        if (languagePreferred != null && !languagePreferred.equals("") && languagePreferred != this.configuration.getLanguage()) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        } else if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        }
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (AppliedStereotypePropertyEditPart.this.isActive() && AppliedStereotypePropertyEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            AppliedStereotypePropertyEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && AppliedStereotypePropertyEditPart.this.getEditText().equals(AppliedStereotypePropertyEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            AppliedStereotypePropertyEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            AppliedStereotypePropertyEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        return new PropertyFigureDescriptor();
    }

    public Object getAdapter(Class key) {
        if (key == AppliedStereotypeProperty.class) {
            return new AppliedStereotypeProperty(((View)this.getNotationView().eContainer()).getElement(), (Property)this.resolveSemanticElement());
        }
        return null;
    }

    public class PropertyFigureDescriptor
    extends WrappingLabel {
        public PropertyFigureDescriptor() {
            this.setText("");
            this.setFont(THIS_FONT);
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrappingLabel wrapLabel;

        public TextCellEditorLocator(WrappingLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrappingLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                    rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
                } else {
                    int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                    rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                }
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

