/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpolicies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCommentViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCommentEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public static final String APPLIED_STEREOTYPE_COMMENT = "AppliedStereotypeComment";
    private Node comment;

    public void activate() {
        super.activate();
        this.getDiagramEventBroker().addNotificationListener(this.hostView.eContainer(), (NotificationListener)this);
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener(this.hostView.eContainer(), (NotificationListener)this);
        super.deactivate();
    }

    public void refreshNotationStructure() {
        if (this.hostView != null) {
            this.removeUnappliedStereotypes((View)this.comment);
            if (!this.stereotypeList.isEmpty()) {
                this.refreshStereotypeCommentStructure();
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.comment != null) {
            int eventType = notification.getEventType();
            Element object = StereotypeDisplayUtil.getInstance().getCommentSemanticElement((View)this.comment);
            if (eventType == 4 && notification.getOldValue().equals(this.hostView) && object == null) {
                this.executeAppliedStereotypeCommentDeletion(this.hostEditPart.getEditingDomain(), (View)this.comment);
            }
            if (this.comment.getTargetEdges() != null && eventType == 4 && notification.getOldValue().equals(this.hostView) && this.comment.getTargetEdges().size() == 0) {
                this.executeAppliedStereotypeCommentDeletion(this.hostEditPart.getEditingDomain(), (View)this.comment);
            }
        }
    }

    public void refreshStereotypeCommentStructure() {
        if (this.comment != null) {
            this.removeUnappliedStereotypes((View)this.comment);
        }
        if (!this.stereotypeList.isEmpty()) {
            this.comment = this.createCommentNode();
            if (this.comment != null) {
                for (Stereotype stereotype : this.stereotypeList) {
                    this.refreshStereotypeCompartmentStructure(stereotype);
                    this.getDiagramEventBroker().addNotificationListener((EObject)this.helper.getStereotypeCompartment((View)this.comment, stereotype), (NotificationListener)this);
                    this.refreshStereotypeBraceStructure(stereotype);
                    this.getDiagramEventBroker().addNotificationListener((EObject)this.helper.getStereotypeBraceCompartment((View)this.comment, stereotype), (NotificationListener)this);
                }
            }
        }
    }

    public void removeListener() {
        if (!this.stereotypeList.isEmpty() && this.comment != null) {
            for (Stereotype stereotype : this.stereotypeList) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)this.helper.getStereotypeCompartment((View)this.comment, stereotype), (NotificationListener)this);
                this.getDiagramEventBroker().removeNotificationListener((EObject)this.helper.getStereotypeBraceCompartment((View)this.comment, stereotype), (NotificationListener)this);
            }
        }
    }

    protected void refreshStereotypeDisplay() {
        super.refreshStereotypeDisplay();
        if (this.comment != null && this.getAppliedStereotypeCompartmentNumber((View)this.comment) == 0) {
            this.executeAppliedStereotypeCommentDeletion(this.hostEditPart.getEditingDomain(), (View)this.comment);
        }
    }

    protected int getAppliedStereotypeCompartmentNumber(View view) {
        int nbVisibleCompartment = 0;
        for (View subview : view.getChildren()) {
            if (!this.helper.isStereotypeBrace((Object)subview) && !this.helper.isStereotypeCompartment((Object)subview)) continue;
            ++nbVisibleCompartment;
        }
        return nbVisibleCompartment;
    }

    public void refreshStereotypeBraceStructure(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostView, stereotype);
        if (compartment == null) {
            this.createAppliedStereotypeBraceCompartment(stereotype);
            this.createAppliedStereotypeBraceProperties(stereotype);
        }
    }

    public void refreshStereotypeCompartmentStructure(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment((View)this.comment, stereotype);
        if (compartment == null) {
            this.createAppliedStereotypeCompartment(stereotype);
        }
        this.createAppliedStereotypeProperties(stereotype);
    }

    protected void createAppliedStereotypeCompartment(Stereotype stereotype) {
        View node = this.hostEditPart.getNotationView();
        if (!this.helper.isCompartmentExist(node, stereotype)) {
            this.executeAppliedStereotypeCompartmentCreation(this.hostEditPart, stereotype, "StereotypeCompartment");
        }
    }

    protected void createAppliedStereotypeProperties(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment((View)this.comment, stereotype);
        if (compartment != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                this.createAppliedStereotypeProperty((Node)compartment, property);
            }
        }
    }

    protected void createAppliedStereotypeProperty(Node compartment, Property property) {
        if (property != null && !property.getName().startsWith("base_") && !this.helper.isPropertyExist((View)compartment, property)) {
            this.executeAppliedStereotypePropertyViewCreation(this.hostEditPart, compartment, property);
        }
    }

    protected void createAppliedStereotypeBraceCompartment(Stereotype stereotype) {
        View node = this.hostEditPart.getNotationView();
        if (!this.helper.isCompartmentExist(node, stereotype)) {
            this.executeAppliedStereotypeCompartmentCreation(this.hostEditPart, stereotype, "StereotypeBrace");
        }
    }

    protected void createAppliedStereotypeBraceProperties(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeBraceCompartment((View)this.comment, stereotype);
        if (compartment != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                this.createAppliedStereotypeBraceProperty((Node)compartment, property);
            }
        }
    }

    private Node createCommentNode() {
        if (this.helper.getStereotypeComment(this.hostView) == null) {
            if (this.getHost() instanceof ConnectionEditPart) {
                this.executeAppliedStereotypeCommentCreation(((ConnectionEditPart)this.getHost()).resolveSemanticElement());
            }
            if (this.getHost() instanceof GraphicalEditPart) {
                this.executeAppliedStereotypeCommentCreation(((GraphicalEditPart)this.getHost()).resolveSemanticElement());
            }
        }
        return this.helper.getStereotypeComment(this.hostView);
    }

    protected void executeAppliedStereotypeCompartmentCreation(final IGraphicalEditPart editPart, final Stereotype stereotype, final String type) {
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(editPart.getEditingDomain(), (View)AppliedStereotypeCommentEditPolicy.this.comment, stereotype, type);
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (Command)command);
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void executeAppliedStereotypePropertyViewCreation(final IGraphicalEditPart editPart, final Node compartment, final Property stereotypeProperty) {
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(editPart.getEditingDomain(), (View)compartment, stereotypeProperty, "StereotypeProperty");
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (Command)command);
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void executeAppliedStereotypeCommentCreation(final EObject node) {
        final TransactionalEditingDomain domain = this.hostEditPart.getEditingDomain();
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                LayoutConstraint constraint;
                int x = 200;
                int y = 100;
                if (AppliedStereotypeCommentEditPolicy.this.hostEditPart.getModel() instanceof Node && (constraint = ((Node)AppliedStereotypeCommentEditPolicy.this.hostEditPart.getModel()).getLayoutConstraint()) instanceof Bounds) {
                    x += ((Bounds)constraint).getX();
                    y = ((Bounds)constraint).getY();
                }
                if (AppliedStereotypeCommentEditPolicy.this.hostEditPart.getModel() instanceof Edge && ((Edge)AppliedStereotypeCommentEditPolicy.this.hostEditPart.getModel()).getSource() instanceof Node && (constraint = ((Node)((Edge)AppliedStereotypeCommentEditPolicy.this.hostEditPart.getModel()).getSource()).getLayoutConstraint()) instanceof Bounds) {
                    x += ((Bounds)constraint).getX();
                    y = ((Bounds)constraint).getY() - 100;
                }
                boolean isBorderElement = false;
                if (AppliedStereotypeCommentEditPolicy.this.hostEditPart instanceof BorderedBorderItemEditPart) {
                    isBorderElement = true;
                }
                if (AppliedStereotypeCommentEditPolicy.this.helper.getStereotypeComment((View)AppliedStereotypeCommentEditPolicy.this.getHost().getModel()) == null) {
                    CreateAppliedStereotypeCommentViewCommand command = new CreateAppliedStereotypeCommentViewCommand(domain, (View)AppliedStereotypeCommentEditPolicy.this.hostEditPart.getModel(), x, y, node, isBorderElement);
                    try {
                        GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)command);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
        });
    }

    protected void executeAppliedStereotypeCommentDeletion(final TransactionalEditingDomain domain, final View commentNode) {
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                if (commentNode != null && TransactionUtil.getEditingDomain((EObject)commentNode) != null) {
                    DeleteCommand command = new DeleteCommand(commentNode);
                    try {
                        GMFUnsafe.write((TransactionalEditingDomain)domain, (ICommand)command);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
        });
    }

    protected Node getNotationNode() {
        View view;
        Node node = null;
        if (this.hostEditPart != null && (view = this.hostEditPart.getNotationView()) instanceof Node) {
            node = (Node)view;
        }
        return node;
    }
}

