/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpolicies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCompartmentEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public static final String STEREOTYPE_LABEL_POLICY = "AppliedStereotypeCompartmentEditPolicy";

    public void refreshStereotypeStructure() {
        if (!this.stereotypeList.isEmpty()) {
            for (Stereotype stereotype : this.stereotypeList) {
                this.refreshStereotypeCompartmentStructure(stereotype);
                this.getDiagramEventBroker().addNotificationListener((EObject)this.helper.getStereotypeCompartment(this.hostView, stereotype), (NotificationListener)this);
            }
        }
    }

    protected void refreshStereotypeDisplay() {
    }

    public void removeListener() {
        if (!this.stereotypeList.isEmpty()) {
            for (Stereotype stereotype : this.stereotypeList) {
                BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostView, stereotype);
                if (compartment == null || stereotype == null) continue;
                this.getDiagramEventBroker().removeNotificationListener((EObject)compartment, (NotificationListener)this);
                EList properties = stereotype.allAttributes();
                for (Property property : properties) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)this.helper.getStereotypeProperty(this.hostView, stereotype, property), (NotificationListener)this);
                }
            }
        }
    }

    protected void refreshStereotypeCompartmentStructure(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostView, stereotype);
        if (compartment == null) {
            this.createAppliedStereotypeCompartment(stereotype);
        }
        this.createAppliedStereotypeProperties(stereotype);
    }

    protected void createAppliedStereotypeCompartment(Stereotype stereotype) {
        View node = this.hostEditPart.getNotationView();
        if (!this.helper.isCompartmentExist(node, stereotype)) {
            this.executeAppliedStereotypeCompartmentCreation(this.hostEditPart, stereotype);
        }
    }

    protected void createAppliedStereotypeProperties(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostEditPart.getNotationView(), stereotype);
        if (compartment != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                this.createAppliedStereotypeProperty((Node)compartment, property);
                this.getDiagramEventBroker().addNotificationListener((EObject)this.helper.getStereotypeProperty(this.hostView, stereotype, property), (NotificationListener)this);
            }
        }
    }

    protected void createAppliedStereotypeProperty(Node compartment, Property property) {
        if (property != null && !property.getName().startsWith("base_") && !this.helper.isPropertyExist((View)compartment, property)) {
            this.executeAppliedStereotypePropertyViewCreation(this.hostEditPart, compartment, property);
        }
    }

    protected void executeAppliedStereotypeCompartmentCreation(final IGraphicalEditPart editPart, final Stereotype stereotype) {
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(editPart.getEditingDomain(), editPart.getNotationView(), stereotype, "StereotypeCompartment");
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (Command)command);
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void executeAppliedStereotypePropertyViewCreation(final IGraphicalEditPart editPart, final Node compartment, final Property stereotypeProperty) {
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(editPart.getEditingDomain(), (View)compartment, stereotypeProperty, "StereotypeProperty");
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (Command)command);
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }
}

