/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.ITypeCatalog;
import org.eclipse.papyrus.uml.profile.drafter.utils.UMLPrimitiveTypesModel;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Type;

public class AccessibleTypeCatalog
implements ITypeCatalog {
    protected Element element;
    protected UMLPrimitiveTypesModel primitiveTypesModel;

    public AccessibleTypeCatalog(Element element) {
        this.element = element;
        try {
            this.primitiveTypesModel = new UMLPrimitiveTypesModel(element.eResource().getResourceSet());
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    public AccessibleTypeCatalog(Element element, UMLPrimitiveTypesModel primitiveTypesLibrary) {
        this.element = element;
        this.primitiveTypesModel = primitiveTypesLibrary;
    }

    public String getTypeLabel(Type type) {
        return type.getLabel();
    }

    public Type getType(String typeLabel) throws NotFoundException {
        for (Type type : this.getTypes()) {
            if (!type.getLabel().equals(typeLabel)) continue;
            return type;
        }
        throw new NotFoundException("No type found under name '" + typeLabel + "'.");
    }

    @Override
    public List<Type> getTypes() {
        if (this.primitiveTypesModel != null) {
            return this.primitiveTypesModel.getLibraryPackage().getOwnedTypes();
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<Type> iterator() {
        return this.getTypes().iterator();
    }
}

