/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.resourceloading.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.services.resourceloading.util.LoadingUtils;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.papyrus.views.modelexplorer.resourceloading.handler.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class UnloadResourceHandler
extends AbstractCommandHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        List selection = this.getSelectedElements();
        if (editingDomain != null && editingDomain.getResourceSet() instanceof ModelSet && selection.size() > 0) {
            ModelSet set = (ModelSet)editingDomain.getResourceSet();
            class NonDirtyingCompound
            extends CompoundCommand
            implements AbstractCommand.NonDirtying {
                NonDirtyingCompound() {
                }
            }
            NonDirtyingCompound command = new NonDirtyingCompound();
            IEditorPart editor = this.getEditor();
            SaveIfNecessaryCommand save = null;
            if (editor.isDirty()) {
                save = new SaveIfNecessaryCommand(editor);
                command.append((Command)save);
            }
            ArrayList<URI> handledURI = new ArrayList<URI>();
            URI mainURI = SashModelUtils.getSashModel((ModelSet)set).getResourceURI().trimFileExtension();
            handledURI.add(mainURI);
            for (EObject sel : selection) {
                Resource resource;
                URI uriTrim;
                if (sel.eIsProxy() || handledURI.contains(uriTrim = (resource = sel.eResource()).getURI().trimFileExtension())) continue;
                handledURI.add(uriTrim);
                if (save != null && set.shouldSave(resource)) {
                    save.setNeedsSave(true);
                }
                class UnloadCommand
                extends AbstractCommand
                implements AbstractCommand.NonDirtying {
                    private final /* synthetic */ ModelSet val$set;
                    private final /* synthetic */ URI val$uriTrim;

                    UnloadCommand(ModelSet modelSet, URI uRI) {
                        this.val$set = modelSet;
                        this.val$uriTrim = uRI;
                    }

                    public void redo() {
                        LoadingUtils.unloadResourcesFromModelSet((ModelSet)this.val$set, (URI)this.val$uriTrim);
                    }

                    public void execute() {
                        this.redo();
                    }

                    public boolean canExecute() {
                        return true;
                    }
                }
                command.append((Command)new UnloadCommand(set, uriTrim));
            }
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IEditorPart getEditor() {
        IWorkbenchPage activePage;
        IEditorPart editor = null;
        IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            editor = activePage.getActiveEditor();
        }
        return editor;
    }

    protected IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    private static class SaveIfNecessaryCommand
    extends AbstractCommand
    implements AbstractCommand.NonDirtying {
        private final IEditorPart editor;
        private boolean needsSave;

        SaveIfNecessaryCommand(IEditorPart editor) {
            this.editor = editor;
        }

        protected boolean prepare() {
            return true;
        }

        void setNeedsSave(boolean needsSave) {
            this.needsSave = needsSave;
        }

        boolean needsSave() {
            return this.needsSave;
        }

        public void execute() {
            if (this.needsSave()) {
                if (this.promptToSave()) {
                    this.save();
                } else {
                    throw new OperationCanceledException();
                }
            }
        }

        public void undo() {
        }

        public void redo() {
        }

        boolean promptToSave() {
            Shell parent = this.editor.getEditorSite().getShell();
            boolean yesIndex = false;
            MessageDialog dlg = new MessageDialog(parent, Messages.UnloadResourceHandler_0, null, Messages.UnloadResourceHandler_1, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            return dlg.open() == 0;
        }

        void save() {
            IProgressService progress = (IProgressService)this.editor.getSite().getService(IProgressService.class);
            try {
                progress.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SaveIfNecessaryCommand.this.editor.doSave(monitor);
                    }
                });
            }
            catch (Exception e) {
                StatusAdapter status = new StatusAdapter((IStatus)new Status(4, "org.eclipse.papyrus.views.modelexplorer.resourceloading", Messages.UnloadResourceHandler_2));
                status.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.UnloadResourceHandler_3);
                StatusManager.getManager().handle(status, 3);
            }
        }
    }
}

