/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.providers;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class ContainerContentProvider
extends SemanticEMFContentProvider {
    protected EClass type;
    protected Object input;

    public ContainerContentProvider(EObject source, EReference reference) {
        super(source.eResource().getResourceSet());
        this.type = (EClass)reference.getEType();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.input = newInput;
        if (newInput instanceof EObject) {
            this.type = ((EObject)newInput).eClass();
        }
    }

    public boolean isValidValue(Object value) {
        Object adaptedValue = this.getAdaptedValue(value);
        if (adaptedValue instanceof EObject) {
            if (EMFHelper.isReadOnly((EObject)((EObject)adaptedValue))) {
                return false;
            }
            for (EReference reference : ((EObject)adaptedValue).eClass().getEAllReferences()) {
                if (!reference.isContainment() || !EMFHelper.isSubclass((EClass)this.type, (EClass)reference.getEReferenceType())) continue;
                return true;
            }
        }
        return false;
    }
}

