/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.analysis.types.FunctionType;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTFunctionParNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTPrefixSpecNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.vpg.AnnotationType;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;

class SubprogramTypeCollector
extends BindingCollector {
    SubprogramTypeCollector() {
    }

    @Override
    public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
        super.traverseChildren(node);
        PhotranTokenRef tokenRef = node.getSubroutineName().getSubroutineName().getTokenRef();
        IASTListNode<ASTSubroutineParNode> subParams = node.getSubroutinePars();
        this.updateDefinitionWithTypeInfo(tokenRef, this.typeOf(node));
        this.updateDefinitionWithSubParameters(tokenRef, this.typeOf(node), subParams);
    }

    @Override
    public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
        super.traverseChildren(node);
        PhotranTokenRef tokenRef = node.getFunctionName().getFunctionName().getTokenRef();
        IASTListNode<ASTFunctionParNode> funParams = node.getFunctionPars();
        this.updateDefinitionWithTypeInfo(tokenRef, this.typeOf(node));
        this.updateDefinitionWithFunParameters(tokenRef, this.typeOf(node), funParams);
    }

    private void updateDefinitionWithTypeInfo(PhotranTokenRef tokenRef, FunctionType type) {
        Definition def = this.vpg.getDefinitionFor(tokenRef);
        def.setType(type);
        this.vpgProvider.setDefinitionFor(tokenRef, def);
    }

    private void updateDefinitionWithSubParameters(PhotranTokenRef tokenRef, FunctionType type, IASTListNode<ASTSubroutineParNode> subParams) {
        Definition def = this.vpg.getDefinitionFor(tokenRef);
        StringBuilder fullId = new StringBuilder(40);
        fullId.append(def.getDeclaredName());
        fullId.append('(');
        if (subParams != null) {
            int paramCount = 0;
            for (ASTSubroutineParNode param : subParams) {
                Definition varDef;
                Token tmpToken = param.getVariableName();
                String paramText = tmpToken != null ? tmpToken.getText() : "*";
                if (paramCount > 0) {
                    fullId.append(',');
                }
                fullId.append(paramText);
                if (tmpToken != null && (varDef = this.bindUniquely(tmpToken)) != null && varDef.isOptional()) {
                    fullId.append('=');
                    fullId.append(paramText);
                }
                ++paramCount;
            }
        }
        fullId.append(')');
        def.setCompletionText(fullId.toString());
        this.vpgProvider.setDefinitionFor(tokenRef, def);
    }

    private void updateDefinitionWithFunParameters(PhotranTokenRef tokenRef, FunctionType type, IASTListNode<ASTFunctionParNode> funParams) {
        Definition def = this.vpg.getDefinitionFor(tokenRef);
        StringBuilder fullId = new StringBuilder(40);
        fullId.append(def.getDeclaredName());
        fullId.append('(');
        if (funParams != null) {
            int paramCount = 0;
            for (ASTFunctionParNode param : funParams) {
                Token tmpToken = param.getVariableName();
                String paramText = tmpToken.getText();
                if (paramCount > 0) {
                    fullId.append(',');
                }
                fullId.append(paramText);
                Definition varDef = this.bindUniquely(tmpToken);
                if (varDef != null && varDef.isOptional()) {
                    fullId.append('=');
                    fullId.append(paramText);
                }
                ++paramCount;
            }
        }
        fullId.append(')');
        def.setCompletionText(fullId.toString());
        this.vpgProvider.setDefinitionFor(tokenRef, def);
    }

    private FunctionType typeOf(ASTSubroutineStmtNode node) {
        FunctionType type = new FunctionType(node.getSubroutineName().getSubroutineName().getText());
        type.setReturnType(Type.VOID);
        if (node.getSubroutinePars() != null) {
            for (ASTSubroutineParNode param : node.getSubroutinePars()) {
                if (param.isAsterisk()) continue;
                type.addArgument(param.getVariableName().getText(), this.typeOf(param.getVariableName()), this.intentOf(param.getVariableName()));
            }
        }
        return type;
    }

    private FunctionType typeOf(ASTFunctionStmtNode node) {
        FunctionType type = new FunctionType(node.getFunctionName().getFunctionName().getText());
        if (node.getPrefixSpecList() != null) {
            int i = 0;
            while (i < node.getPrefixSpecList().size()) {
                ASTTypeSpecNode typeSpec = ((ASTPrefixSpecNode)node.getPrefixSpecList().get(i)).getTypeSpec();
                if (typeSpec != null) {
                    type.setReturnType(Type.parse(typeSpec));
                }
                ++i;
            }
        }
        if (node.hasResultClause()) {
            type.setReturnType(this.typeOf(node.getName()));
        }
        if (node.getFunctionPars() != null) {
            for (ASTFunctionParNode param : node.getFunctionPars()) {
                type.addArgument(param.getVariableName().getText(), this.typeOf(param.getVariableName()), this.intentOf(param.getVariableName()));
            }
        }
        return type;
    }

    private Type typeOf(Token variableName) {
        Definition def = this.bindUniquely(variableName);
        return def == null ? Type.UNKNOWN : def.getType();
    }

    private VariableAccess intentOf(Token variableName) {
        Definition def = this.bindUniquely(variableName);
        if (def == null) {
            return VariableAccess.RW;
        }
        if (def.isIntentIn() && def.isIntentOut()) {
            return VariableAccess.RW;
        }
        if (def.isIntentIn()) {
            return VariableAccess.READ;
        }
        if (def.isIntentOut()) {
            return VariableAccess.WRITE;
        }
        return VariableAccess.RW;
    }

    private Definition bindUniquely(Token ident) {
        List<PhotranTokenRef> bindings = this.bind(ident);
        if (bindings.size() >= 1) {
            return (Definition)bindings.get(0).getAnnotation(AnnotationType.DEFINITION_ANNOTATION_TYPE);
        }
        return null;
    }
}

