/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.photran.internal.core.refactoring.IRefactoring;
import org.eclipse.photran.internal.core.refactoring.UserInputBoolean;
import org.eclipse.photran.internal.core.refactoring.UserInputString;
import org.eclipse.photran.internal.ui.UIUtil;
import org.eclipse.photran.internal.ui.actions.Messages;
import org.eclipse.photran.internal.ui.refactoring.CustomUserInputPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RefactoringAction<T extends Refactoring>
implements IWorkbenchWindowActionDelegate,
IRunnableWithProgress {
    private IWorkbenchWindow activeWindow = null;
    private Shell activeShell = null;
    protected IRefactoring refactoring;
    protected CustomUserInputPage<T> customUserInputPage = null;

    public RefactoringAction(IRefactoring refactoring) {
        this(refactoring, null);
    }

    public RefactoringAction(IRefactoring refactoring, CustomUserInputPage<T> customUserInputPage) {
        this.refactoring = refactoring;
        this.customUserInputPage = customUserInputPage;
    }

    public void init(IWorkbenchWindow window) {
        this.activeWindow = window;
        if (this.activeWindow != null) {
            this.activeShell = this.activeWindow.getShell();
        }
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        this.run((IAction)null);
    }

    public void run(IAction action) {
        if (!(this.refactoring instanceof Refactoring)) {
            UIUtil.displayErrorDialog("ERROR: " + this.refactoring.getClass().getName() + " is not a subclass of org.eclipse.ltk.core.refactoring.Refactoring." + " A custom Action must be provided.");
            return;
        }
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        IWorkspaceRoot lockEntireWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        try {
            context.runInUI((IRunnableContext)context, (IRunnableWithProgress)this, (ISchedulingRule)lockEntireWorkspace);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.activeShell, (String)Messages.RefactoringAction_UnhandledExceptionTitle, (String)e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (this.filesSavedAsNecessary()) {
            String name = this.refactoring.getName();
            DefaultRefactoringWizard wizard = new DefaultRefactoringWizard();
            RefactoringWizardOpenOperation wiz = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            if (this.activeShell == null) {
                this.activeShell = UIUtil.determineActiveShell();
            }
            wiz.run(this.activeShell, name);
        }
    }

    private boolean filesSavedAsNecessary() {
        return UIUtil.askUserToSaveModifiedFiles();
    }

    public class DefaultRefactoringWizard
    extends RefactoringWizard {
        public DefaultRefactoringWizard() {
            super((Refactoring)RefactoringAction.this.refactoring, 4);
            this.setNeedsProgressMonitor(true);
            this.setChangeCreationCancelable(false);
            this.setWindowTitle(this.getRefactoring().getName());
            if (RefactoringAction.this.customUserInputPage != null) {
                RefactoringAction.this.customUserInputPage.setRefactoring(this.getRefactoring());
            }
        }

        protected final void addUserInputPages() {
            this.setDefaultPageTitle(RefactoringAction.this.refactoring.getName());
            if (RefactoringAction.this.customUserInputPage != null) {
                this.addPage((IWizardPage)RefactoringAction.this.customUserInputPage);
            } else if (this.hasAnnotatedMethods()) {
                this.addPage((IWizardPage)new SimpleUserInputWizardPage(RefactoringAction.this.refactoring.getName()));
            } else {
                this.addPage((IWizardPage)new NoUserInputWizardPage(RefactoringAction.this.refactoring.getName()));
            }
        }

        private boolean hasAnnotatedMethods() {
            Method[] methodArray = RefactoringAction.this.refactoring.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getAnnotation(UserInputString.class) != null || method.getAnnotation(UserInputBoolean.class) != null) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private final class NoUserInputWizardPage
    extends UserInputWizardPage {
        private NoUserInputWizardPage(String name) {
            super(name);
        }

        public void createControl(Composite parent) {
            Composite top = new Composite(parent, 0);
            this.initializeDialogUnits((Control)top);
            this.setControl((Control)top);
            top.setLayout((Layout)new GridLayout(1, false));
            Label lbl = new Label(top, 0);
            lbl.setText(Messages.bind((String)Messages.RefactoringAction_ClickOKToRunTheRefactoring, (Object)RefactoringAction.this.refactoring.getName()));
        }
    }

    private final class SimpleUserInputWizardPage
    extends UserInputWizardPage {
        private Control firstField;

        private SimpleUserInputWizardPage(String name) {
            super(name);
            this.firstField = null;
        }

        public void createControl(Composite parent) {
            Composite top = new Composite(parent, 0);
            this.initializeDialogUnits((Control)top);
            this.setControl((Control)top);
            top.setLayout((Layout)new GridLayout(2, false));
            this.addContolsFromAnnotatedFields(top);
        }

        private void addContolsFromAnnotatedFields(Composite group) {
            Method[] methodArray = RefactoringAction.this.refactoring.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                UserInputBoolean annotation;
                Method method = methodArray[n2];
                UserInputString stringAnnotation = method.getAnnotation(UserInputString.class);
                if (stringAnnotation != null) {
                    this.checkMethodSignature(method, String.class);
                    String defaultValue = this.getDefaultValue(RefactoringAction.this.refactoring, stringAnnotation.defaultValueMethod());
                    this.addTextField(group, stringAnnotation.label(), defaultValue, method);
                }
                if ((annotation = method.getAnnotation(UserInputBoolean.class)) != null) {
                    this.checkMethodSignature(method, Boolean.TYPE);
                    this.addCheckBoxField(group, annotation.label(), annotation.defaultValue(), method);
                }
                ++n2;
            }
        }

        private void checkMethodSignature(Method method, Class<?> parameterType) {
            if (!method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(parameterType)) {
                throw new IllegalArgumentException("The method " + method.getName() + " may not have the @UserInput " + "annotation unless it has the following signature:\n" + "    void " + method.getName() + "(" + parameterType.getSimpleName() + ")");
            }
        }

        private String getDefaultValue(IRefactoring refactoring, String defaultValueMethod) {
            try {
                if (defaultValueMethod != null && !defaultValueMethod.equals("")) {
                    Method getter = refactoring.getClass().getMethod(defaultValueMethod, new Class[0]);
                    String result = getter.invoke((Object)refactoring, new Object[0]).toString();
                    return result == null ? "" : result;
                }
                return "";
            }
            catch (Throwable e) {
                e.printStackTrace();
                return "";
            }
        }

        private void addTextField(Composite group, String label, String defaultValue, final Method method) {
            Label lbl = new Label(group, 0);
            lbl.setText(label);
            final Text newNameField = new Text(group, 2048);
            newNameField.setText(defaultValue);
            this.setString(method, defaultValue);
            newNameField.setLayoutData((Object)new GridData(768));
            newNameField.selectAll();
            newNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SimpleUserInputWizardPage.this.setString(method, newNameField.getText());
                }
            });
            if (this.firstField == null) {
                this.firstField = newNameField;
            }
        }

        private void setString(Method method, String value) {
            try {
                method.invoke((Object)RefactoringAction.this.refactoring, value);
            }
            catch (Exception x) {
                throw new Error(x);
            }
        }

        private void addCheckBoxField(Composite group, String label, boolean defaultValue, final Method method) {
            new Label(group, 0).setText("");
            final Button button = new Button(group, 32);
            button.setText(label);
            button.setSelection(defaultValue);
            this.setBoolean(method, defaultValue);
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    SimpleUserInputWizardPage.this.setBoolean(method, button.getSelection());
                }
            });
            if (this.firstField == null) {
                this.firstField = button;
            }
        }

        private void setBoolean(Method method, boolean isChecked) {
            try {
                method.invoke((Object)RefactoringAction.this.refactoring, isChecked);
            }
            catch (Exception x) {
                throw new Error(x);
            }
        }
    }
}

