/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.ScriptletDefinition;
import org.eclipse.rcptt.ecl.runtime.FQName;
import org.eclipse.rcptt.ecl.runtime.ICommandService;

public class ScriptletManager {
    static final String SCRIPTLET_EXTPT = "org.eclipse.rcptt.ecl.core.scriptlet";
    public static final String SCRIPTLET_NAME_ATTR = "name";
    public static final String SCRIPTLET_NAMESPACE_ATTR = "namespace";
    public static final String SCRIPTLET_CLASS_ATTR = "class";
    public static final boolean TRACE_REGISTERED_COMMANDS = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.rcptt.ecl.core/traceRegisteredCommands"));
    private Map<FQName, ScriptletDefinition> scriptlets;

    synchronized ICommandService getScriptletService(Command scriptlet) throws CoreException {
        String ns = scriptlet.eClass().getEPackage().getNsURI();
        String name = scriptlet.eClass().getName();
        return this.getScriptletDefinition(ns, name).getService();
    }

    public synchronized EClass findCommand(String ns, String name) throws CoreException {
        return this.getScriptletDefinition(ns, name).getEClass();
    }

    public synchronized Command createCommand(String ns, String name) throws CoreException {
        EClass clazz = this.getScriptletDefinition(ns, name).getEClass();
        return (Command)clazz.getEPackage().getEFactoryInstance().create(clazz);
    }

    private synchronized ScriptletDefinition getScriptletDefinition(String ns, String name) throws CoreException {
        FQName fqn;
        ScriptletDefinition def;
        if (this.scriptlets == null) {
            this.loadScriptlets();
        }
        if ((def = this.scriptlets.get(fqn = new FQName(ns, name))) == null) {
            FQName fqname = null;
            for (FQName d : this.scriptlets.keySet()) {
                if (d.name.equals(name)) {
                    if (fqname == null) {
                        fqname = d;
                        continue;
                    }
                    fqname = null;
                    break;
                }
                ScriptletDefinition sd = this.scriptlets.get(d);
                Set<String> friendlyNames = sd.getFriendlyNames();
                if (!friendlyNames.contains(name)) continue;
                if (fqname == null) {
                    fqname = d;
                    continue;
                }
                fqname = null;
                break;
            }
            if (fqname != null) {
                def = this.scriptlets.get(fqname);
            }
        }
        if (def == null) {
            Status status = new Status(4, "org.eclipse.rcptt.ecl.core", MessageFormat.format("Scriptlet {0} not found", fqn));
            if (TRACE_REGISTERED_COMMANDS) {
                System.out.println(status.getMessage());
            }
            throw new CoreException((IStatus)status);
        }
        return def;
    }

    public synchronized Set<FQName> getAllCommandNames() {
        if (this.scriptlets == null) {
            this.loadScriptlets();
        }
        return this.scriptlets.keySet();
    }

    public synchronized Set<String> getAllFriendlyNames() {
        if (this.scriptlets == null) {
            this.loadScriptlets();
        }
        HashSet<String> all = new HashSet<String>();
        for (ScriptletDefinition def : this.scriptlets.values()) {
            all.addAll(def.getFriendlyNames());
        }
        return all;
    }

    public synchronized Set<String> getFriendlyNames(String ns, String name) throws CoreException {
        ScriptletDefinition def = this.getScriptletDefinition(ns, name);
        return def == null ? null : def.getFriendlyNames();
    }

    private void loadScriptlets() {
        IConfigurationElement[] configs;
        this.scriptlets = new HashMap<FQName, ScriptletDefinition>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(SCRIPTLET_EXTPT);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String ns = config.getAttribute(SCRIPTLET_NAMESPACE_ATTR);
            String name = config.getAttribute(SCRIPTLET_NAME_ATTR);
            try {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ns);
                Assert.isLegal((ePackage != null ? 1 : 0) != 0, (String)("Unknown package nsURI=" + ns));
                Assert.isLegal((ePackage.getEClassifier(name) != null ? 1 : 0) != 0, (String)("Unknown class=" + name + " in package=" + ePackage.getName()));
                FQName fqn = new FQName(ns, name);
                if (TRACE_REGISTERED_COMMANDS) {
                    System.out.println("Loaded definition of command " + fqn);
                }
                this.scriptlets.put(fqn, new ScriptletDefinition(ns, name, config));
            }
            catch (Exception e) {
                CorePlugin.log(CorePlugin.err("Failed to load scriptlet " + name + ": " + e.getMessage(), e));
            }
            ++n2;
        }
    }
}

