/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.server;

import java.util.List;
import org.eclipse.riena.demo.common.Email;
import org.eclipse.riena.demo.common.IEmailService;
import org.eclipse.riena.demo.server.IEmailRepository;

public class EmailService
implements IEmailService {
    private IEmailRepository emailRepository;

    public EmailService() {
        System.out.println("email service started");
    }

    public void bind(IEmailRepository emailRepository) {
        this.emailRepository = emailRepository;
        System.out.println("email service: repository bound");
    }

    public void unbind(IEmailRepository emailRepository) {
        this.emailRepository = null;
        System.out.println("email service: repository unbound");
    }

    public IEmailRepository getRepository() {
        return this.emailRepository;
    }

    public List<Email> showEmailsList(String directoryName) {
        return this.emailRepository.emailsList(directoryName);
    }

    public List<Email> findEmailsForCustomer(String emailAddress) {
        return this.emailRepository.findEmailsForCustomer(emailAddress);
    }

    public boolean store(Email email) {
        try {
            this.emailRepository.store(email);
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }
}

