/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.net.URI;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.riena.core.singleton.SessionSingletonProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.FileUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.navigation.ui.swt.views.ImageReplacer;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.riena.ui.swt.utils.ImageStore;

public class E4ImageReplacer
extends ImageReplacer {
    private static final SingletonProvider<E4ImageReplacer> IR = new SessionSingletonProvider(E4ImageReplacer.class);
    private static final String IMAGES_REPLACED_KEY = "e4_image_replacer_images_replaced";

    public static E4ImageReplacer getInstance() {
        return (E4ImageReplacer)((Object)IR.getInstance());
    }

    public void replaceImages(IContributionItem item) {
        if (item instanceof HandledContributionItem) {
            MHandledItem handledItem = ((HandledContributionItem)item).getModel();
            this.replaceImages(handledItem);
        } else {
            super.replaceImages(item);
        }
    }

    private void replaceImages(MHandledItem item) {
        Object obj = item.getTransientData().get(IMAGES_REPLACED_KEY);
        if (Boolean.TRUE.equals(obj)) {
            return;
        }
        String iconUri = item.getIconURI();
        if (!StringUtils.isEmpty((CharSequence)(iconUri = this.getReplaceUri(iconUri)))) {
            item.setIconURI(iconUri);
        }
        iconUri = this.getDisabledIconURI(item);
        if (!StringUtils.isEmpty((CharSequence)(iconUri = this.getReplaceUri(iconUri)))) {
            this.setDisabledIconURI((MItem)item, iconUri);
        }
        item.getTransientData().put(IMAGES_REPLACED_KEY, true);
    }

    private String getDisabledIconURI(MHandledItem item) {
        Object obj = item.getTransientData().get("e4_disabled_icon_image_key");
        return obj instanceof String ? (String)obj : "";
    }

    private void setDisabledIconURI(MItem item, String iconUri) {
        item.getTransientData().put("e4_disabled_icon_image_key", iconUri);
    }

    private String getReplaceUri(String iconUri) {
        if (!StringUtils.isEmpty((CharSequence)iconUri)) {
            URI uri = URI.create(iconUri);
            String imageName = this.getImageName(uri);
            String fileExtension = FileUtils.getFileExtension((String)uri.getPath());
            ImageFileExtension imageFileExtension = ImageFileExtension.getImageFileExtension((String)fileExtension);
            if (imageFileExtension == null) {
                imageFileExtension = ImageFileExtension.PNG;
            }
            if ((uri = ImageStore.getInstance().getImageUri(imageName, imageFileExtension)) != null) {
                return uri.toString();
            }
        }
        return null;
    }

    public static /* bridge */ /* synthetic */ ImageReplacer getInstance() {
        return E4ImageReplacer.getInstance();
    }
}

