/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.rendering;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.ui.swt.layout.DpiGridLayout;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PerspectiveRenderer
extends SWTPartRenderer {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), PerspectiveRenderer.class);
    private Composite navigationPart;
    private Composite contents;

    public Widget createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPerspective)) {
            LOGGER.log(2, "element '" + element + "' isn't a MPerspective");
            return null;
        }
        if (!(parent instanceof Composite)) {
            LOGGER.log(2, "parent '" + parent + "' isn't a SWT Composite");
            return null;
        }
        Composite subApplicationComposite = new Composite((Composite)parent, 0);
        DpiGridLayout layout = new DpiGridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginRight = LnfManager.getLnf().getIntegerSetting("TitlelessShellSubModuleHorizontal.gap");
        layout.marginTop = LnfManager.getLnf().getIntegerSetting("toolbar.workarea.vertical.gap");
        subApplicationComposite.setLayout((Layout)layout);
        this.navigationPart = new Composite(subApplicationComposite, 0);
        GridData navigationLayoutData = new GridData(1040);
        navigationLayoutData.widthHint = LnfManager.getLnf().getIntegerSetting("navigation.width");
        navigationLayoutData.horizontalIndent = LnfManager.getLnf().getIntegerSetting("TitlelessShellNavigationHorizontal.gap");
        this.navigationPart.setLayoutData((Object)navigationLayoutData);
        this.navigationPart.setLayout((Layout)new FillLayout());
        this.contents = new Composite(subApplicationComposite, 0);
        GridData contentsLayoutData = new GridData(1808);
        contentsLayoutData.horizontalIndent = LnfManager.getLnf().getIntegerSetting("NavigationSubModule.gap");
        this.contents.setLayoutData((Object)contentsLayoutData);
        this.contents.setLayout((Layout)new FillLayout());
        IStylingEngine stylingEngine = (IStylingEngine)this.getContext(element).get(IStylingEngine.SERVICE_NAME);
        stylingEngine.setClassname((Object)subApplicationComposite, "perspectiveLayout");
        return subApplicationComposite;
    }

    public void processContents(MElementContainer<MUIElement> container) {
        super.processContents(container);
        IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
        MPerspective persp = (MPerspective)container;
        Shell shell = ((Composite)persp.getWidget()).getShell();
        for (MWindow dw : persp.getWindows()) {
            renderer.createGui((MUIElement)dw, (Object)shell, persp.getContext());
        }
    }

    public Object getUIContainer(MUIElement element) {
        if ("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart".equals(element.getElementId())) {
            return this.navigationPart;
        }
        if ("org.eclipse.riena.e4.launcher.contentPartStack".equals(element.getElementId())) {
            return this.contents;
        }
        return null;
    }
}

