/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IImageButtonRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class RidgetsSubModuleController
extends SubModuleController {
    private static final String ICON_SAMPLE = "0140";
    private static final String ICON_YELLOW = "0141";
    private static final String ICON_RED = "0142";
    private final RidgetsModel model = new RidgetsModel();

    public RidgetsSubModuleController() {
        this(null);
    }

    public RidgetsSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.model.setToggleOneSelected(true);
        this.model.setToggleTwoSelected(false);
        this.model.setCheckOneSelected(true);
    }

    public void configureRidgets() {
        super.configureRidgets();
        IToggleButtonRidget toggleOne = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "toggleOne");
        toggleOne.setText("&Toggle 1");
        toggleOne.setIcon(ICON_SAMPLE, IconSize.A16);
        toggleOne.bindToModel((Object)this.model, "toggleOneSelected");
        toggleOne.updateFromModel();
        IToggleButtonRidget toggleTwo = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "toggleTwo");
        toggleTwo.setText("&Toggle 2");
        toggleTwo.bindToModel((Object)this.model, "toggleTwoSelected");
        toggleTwo.updateFromModel();
        IToggleButtonRidget checkOne = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkOne");
        checkOne.setText("C&heck 1");
        checkOne.bindToModel((Object)this.model, "checkOneSelected");
        checkOne.updateFromModel();
        final IActionRidget buttonOne = (IActionRidget)this.getRidget(IActionRidget.class, "buttonOne");
        buttonOne.setText("Button 1");
        buttonOne.setIcon(ICON_SAMPLE, IconSize.A16);
        buttonOne.addListener(new IActionListener(){

            public void callback() {
                buttonOne.setIcon(RidgetsSubModuleController.ICON_RED, IconSize.A16);
                System.out.println("Button clicked...");
            }
        });
        final IActionRidget buttonTwo = (IActionRidget)this.getRidget(IActionRidget.class, "buttonTwo");
        buttonTwo.setText("Button 2");
        buttonTwo.addListener(new IActionListener(){

            public void callback() {
                buttonTwo.setIcon(RidgetsSubModuleController.ICON_YELLOW, IconSize.A16);
                System.out.println("Button clicked...");
            }
        });
        IActionListener actionListener = new IActionListener(){

            public void callback() {
                System.out.println("Button clicked...");
            }
        };
        IActionRidget imageButton = (IActionRidget)this.getRidget(IImageButtonRidget.class, "imageButton");
        imageButton.setIcon("imageBtn");
        imageButton.addListener(actionListener);
        IActionRidget arrowButton = (IActionRidget)this.getRidget(IImageButtonRidget.class, "arrowButton");
        arrowButton.setIcon("arrowRight");
        arrowButton.addListener(actionListener);
        IActionRidget arrowHotButton = (IActionRidget)this.getRidget(IImageButtonRidget.class, "arrowHotButton");
        arrowHotButton.setIcon("arrowRight");
        arrowHotButton.addListener(actionListener);
        IActionRidget cloudSmallButton = (IActionRidget)this.getRidget(IImageButtonRidget.class, "cloudSmallButton");
        cloudSmallButton.setIcon("cloud", IconSize.A16);
        cloudSmallButton.addListener(actionListener);
        IActionRidget cloudBigButton = (IActionRidget)this.getRidget(IImageButtonRidget.class, "cloudBigButton");
        cloudBigButton.setIcon("cloud", IconSize.C32);
        cloudBigButton.addListener(actionListener);
    }

    private static final class RidgetsModel {
        private boolean toggleOneSelected;
        private boolean toggleTwoSelected;
        private boolean checkOneSelected;

        private RidgetsModel() {
        }

        public boolean isToggleOneSelected() {
            return this.toggleOneSelected;
        }

        public void setToggleOneSelected(boolean toggleOneSelected) {
            this.toggleOneSelected = toggleOneSelected;
        }

        public void setToggleTwoSelected(boolean toggleTwoSelected) {
            this.toggleTwoSelected = toggleTwoSelected;
        }

        public boolean isToggleTwoSelected() {
            return this.toggleTwoSelected;
        }

        public boolean isCheckOneSelected() {
            return this.checkOneSelected;
        }

        public void setCheckOneSelected(boolean checkOneSelected) {
            this.checkOneSelected = checkOneSelected;
        }
    }
}

