/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;

public class SystemPropertySourceProvider
extends AbstractSourceProvider {
    private boolean isDisposed;
    private static final String JAVA_VERSION = "java.version";
    private static final String OS_VERSION = "os.version";
    private static final String OS_NAME = "os.name";
    private static final String USER_LANGUAGE = "user.language";
    private static final String USER_NAME = "user.name";
    private static final int EVENT_PRIORITY = Integer.MIN_VALUE;
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"java.version", "os.version", "os.name", "user.language", "user.name"};

    public void dispose() {
        this.isDisposed = true;
    }

    public Map getCurrentState() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(JAVA_VERSION, System.getProperty(JAVA_VERSION));
        properties.put(OS_VERSION, System.getProperty(OS_VERSION));
        properties.put(OS_NAME, System.getProperty(OS_NAME));
        properties.put(USER_LANGUAGE, System.getProperty(USER_LANGUAGE));
        properties.put(USER_NAME, System.getProperty(USER_NAME));
        return properties;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    void fireSourceChange(String propName, String propValue) {
        this.fireSourceChanged(Integer.MIN_VALUE, propName, propValue);
    }

    public void propertyChanged(String propName) {
        if (Arrays.asList(PROVIDED_SOURCE_NAMES).contains(propName)) {
            this.fireSourceChange(propName, System.getProperty(propName));
        }
    }
}

