/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.AbstractNavigationHandler;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;

public class CloseModuleGroup
extends AbstractNavigationHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IApplicationNode application = ApplicationNodeManager.getApplicationNode();
        IModuleGroupNode moduleGroup = this.findModuleGroup(application);
        if (moduleGroup != null && this.isCloseable(moduleGroup)) {
            INavigationNode<?> previous = this.findPreviousModuleGroup(moduleGroup);
            if (previous != null) {
                previous.activate();
            }
            moduleGroup.dispose();
        }
        return null;
    }

    private INavigationNode<?> findPreviousModuleGroup(IModuleGroupNode moduleGroup) {
        List moduleGroups = moduleGroup.getParent().getChildren();
        INavigationNode[] nodes = moduleGroups.toArray(new INavigationNode[moduleGroups.size()]);
        return this.findPreviousNode(nodes, false);
    }

    private boolean isCloseable(IModuleGroupNode moduleGroup) {
        boolean result = true;
        for (IModuleNode module : moduleGroup.getChildren()) {
            boolean bl = result = result && module.isClosable();
        }
        return result;
    }
}

