/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.core.marker.IIconizableMarker;
import org.eclipse.riena.ui.core.marker.UIProcessFinishedMarker;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.FlasherSupportForRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SubModuleTreeItemMarkerRenderer
extends AbstractLnfRenderer {
    private static final MarkerComperator MARKER_COMPERATOR = new MarkerComperator();
    private TreeItem item;
    private FlasherSupportForRenderer flasherSupport = new FlasherSupportForRenderer((ILnfRenderer)this, (Runnable)new MarkerUpdater());
    private static final int IMAGE_MARGIN = 2;

    public void paint(GC gc, Object value) {
        super.paint(gc, value);
        Assert.isNotNull((Object)value);
        Assert.isTrue((boolean)(value instanceof TreeItem));
        this.item = (TreeItem)value;
        this.flasherSupport.startFlasher();
        Collection markers = this.getMarkersOfType(IIconizableMarker.class);
        if (!markers.isEmpty()) {
            this.paintMarkers(gc, markers, this.item);
        }
    }

    protected void paintMarkers(GC gc, Collection<IIconizableMarker> markers, TreeItem item) {
        ArrayList<IIconizableMarker> sortedMarkers = new ArrayList<IIconizableMarker>(markers);
        Collections.sort(sortedMarkers, MARKER_COMPERATOR);
        if (this.isPaintMarkersHierarchically() && sortedMarkers.size() > 0) {
            IIconizableMarker.MarkerPosition position = (IIconizableMarker.MarkerPosition)LnfManager.getLnf().getSetting("subModuleTreePaintMarkerInHierarchicOrder");
            this.paintMarkerImage(gc, (IIconizableMarker)sortedMarkers.get(sortedMarkers.size() - 1), position, item);
        } else {
            for (IIconizableMarker iconizableMarker : sortedMarkers) {
                this.paintMarkerImage(gc, iconizableMarker, iconizableMarker.getPositionOfMarker(), item);
            }
        }
    }

    private boolean isPaintMarkersHierarchically() {
        return LnfManager.getLnf().getSetting("subModuleTreePaintMarkerInHierarchicOrder") instanceof IIconizableMarker.MarkerPosition;
    }

    private void paintMarkerImage(GC gc, IIconizableMarker iconizableMarker, IIconizableMarker.MarkerPosition markerPosition, TreeItem item) {
        if (!iconizableMarker.isVisible()) {
            return;
        }
        if (iconizableMarker instanceof UIProcessFinishedMarker && !this.flasherSupport.isProcessMarkerVisible()) {
            return;
        }
        if (item != null) {
            Image itemImage = item.getImage();
            String key = iconizableMarker.getIconConfigurationKey();
            Image markerImage = LnfManager.getLnf().getImage(key);
            if (markerImage != null) {
                Point pos = this.calcMarkerCoordinates(itemImage, markerImage, markerPosition);
                gc.drawImage(markerImage, pos.x, pos.y);
            }
        }
    }

    private Point calcMarkerCoordinates(Image itemImage, Image markerImage, IIconizableMarker.MarkerPosition position) {
        Rectangle itemImageBounds = new Rectangle(0, 0, 0, 0);
        if (itemImage != null) {
            Rectangle imageBounds = itemImage.getBounds();
            itemImageBounds = new Rectangle(imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height);
        }
        Rectangle itemMarkerBounds = new Rectangle(0, 0, 0, 0);
        if (markerImage != null) {
            Rectangle imageBounds = markerImage.getBounds();
            itemMarkerBounds = new Rectangle(imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height);
        }
        int x = SwtUtilities.convertXToDpi((int)2);
        x += this.getBounds().x;
        x += itemImageBounds.x;
        int y = this.getBounds().y;
        y += itemImageBounds.y;
        switch (position) {
            case TOP_RIGHT: {
                x += itemImageBounds.width - itemMarkerBounds.width;
                break;
            }
            case BOTTOM_LEFT: {
                y += itemImageBounds.height - itemMarkerBounds.height;
                break;
            }
            case BOTTOM_RIGHT: {
                x += itemImageBounds.width - itemMarkerBounds.width;
                y += itemImageBounds.height - itemMarkerBounds.height;
                break;
            }
        }
        return new Point(x, y);
    }

    public void dispose() {
        this.item = null;
        this.flasherSupport = null;
    }

    private static class MarkerComperator
    implements Comparator<IMarker> {
        private MarkerComperator() {
        }

        @Override
        public int compare(IMarker m1, IMarker m2) {
            return m1.getPriority().compareTo((Enum)m2.getPriority());
        }
    }

    private class MarkerUpdater
    implements Runnable {
        private MarkerUpdater() {
        }

        @Override
        public void run() {
            if (!SwtUtilities.isDisposed((Widget)SubModuleTreeItemMarkerRenderer.this.item)) {
                SubModuleTreeItemMarkerRenderer.this.item.getParent().redraw();
            }
        }
    }
}

