/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.simpleservices.sessionservice.store;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.riena.security.common.session.Session;
import org.eclipse.riena.security.sessionservice.ISessionStore;
import org.eclipse.riena.security.sessionservice.SessionEntry;

public class MemoryStore
implements ISessionStore {
    private final HashMap<String, SessionEntry> sessionTable = new HashMap();
    private final HashMap<Principal, SessionList> userTable = new HashMap();

    public synchronized SessionEntry read(Session session) {
        return this.sessionTable.get(session.getSessionId());
    }

    public synchronized void write(SessionEntry entry) {
        this.sessionTable.put(entry.getSession().getSessionId(), entry);
        Principal[] principalArray = entry.getPrincipals().toArray(new Principal[entry.getPrincipals().size()]);
        int n = principalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Principal p = principalArray[n2];
            SessionList sl = this.userTable.get(p);
            if (sl == null) {
                sl = new SessionList();
            }
            sl.addEntry(entry);
            this.userTable.put(p, sl);
            ++n2;
        }
    }

    public synchronized void delete(Session session) {
        SessionEntry entry = this.sessionTable.get(session.getSessionId());
        if (entry == null) {
            return;
        }
        this.sessionTable.remove(session.getSessionId());
        Principal[] principalArray = entry.getPrincipals().toArray(new Principal[entry.getPrincipals().size()]);
        int n = principalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Principal p = principalArray[n2];
            SessionList sl = this.userTable.get(p);
            sl.removeEntry(session);
            ++n2;
        }
    }

    static class SessionList {
        private final HashMap<String, SessionEntry> sessions = new HashMap();
        private static final SessionEntry[] EMPTY_SESSION_ENTRIES = new SessionEntry[0];

        SessionList() {
        }

        public void addEntry(SessionEntry entry) {
            this.sessions.put(entry.getSession().getSessionId(), entry);
        }

        public void removeEntry(Session session) {
            this.sessions.remove(session.getSessionId());
        }

        public SessionEntry[] entries() {
            if (this.sessions.size() == 0) {
                return EMPTY_SESSION_ENTRIES;
            }
            Collection<SessionEntry> values = this.sessions.values();
            return values.toArray(new SessionEntry[values.size()]);
        }
    }
}

