/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.cache;

import java.util.Map;
import org.eclipse.riena.core.cache.LRUHashMap;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;

@NonUITestCase
public class LRUHashMapTest
extends RienaTestCase {
    private final Map<String, Integer> lru = LRUHashMap.createLRUHashMap((int)3);

    public void testInstantiate() {
        LRUHashMapTest.assertEquals((int)0, (int)this.lru.size());
    }

    public void testToTheLimit() {
        this.put(1, 2, 3);
        this.assertContains(1, 2, 3);
        LRUHashMapTest.assertEquals((int)3, (int)this.lru.size());
        this.put(4);
        LRUHashMapTest.assertEquals((int)3, (int)this.lru.size());
        this.assertContains(2, 3, 4);
    }

    public void testOverTheLimitAndTouchInTheMiddle() {
        this.put(1, 2, 3);
        this.assertContains(1, 2, 3);
        LRUHashMapTest.assertEquals((int)3, (int)this.lru.size());
        this.put(4);
        LRUHashMapTest.assertEquals((int)3, (int)this.lru.size());
        this.assertContains(2, 3, 4);
        this.assertContains(2);
        this.put(5);
        this.assertContains(2, 4, 5);
    }

    private void put(int ... kvs) {
        int[] nArray = kvs;
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.lru.put(Integer.toString(i), i);
            ++n2;
        }
    }

    private void assertContains(int ... kvs) {
        int[] nArray = kvs;
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            LRUHashMapTest.assertEquals((Object)i, (Object)this.lru.get(Integer.toString(i)));
            ++n2;
        }
    }
}

