/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.exception;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.exception.IExceptionHandler;
import org.eclipse.riena.core.exception.TestExceptionHandler;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.exceptionmanager.IExceptionHandlerExtension;
import org.eclipse.riena.internal.core.exceptionmanager.SimpleExceptionHandlerManager;

@NonUITestCase
public class SimpleExceptionHandlerManagerTest
extends RienaTestCase {
    private SimpleExceptionHandlerManager manager;

    public void setUp() throws Exception {
        super.setUp();
        this.manager = new SimpleExceptionHandlerManager();
    }

    public void tearDown() throws Exception {
        this.manager = null;
        super.tearDown();
    }

    public void testAddOneHandler() {
        this.manager.update(new IExceptionHandlerExtension[]{this.createHandlerExtension("handler1", "IOE", null, null, null)});
        Exception exception = new Exception("IOE");
        this.manager.handleException((Throwable)exception);
        Assert.assertEquals((String)"expected exception", (String)"handler1", (String)TestExceptionHandler.getHandledName());
    }

    public void testAddTwoHandlersWithNoParticularOrderAndExceptionNotHandled1() {
        this.manager.update(new IExceptionHandlerExtension[]{this.createHandlerExtension("handler1", "IAE", "handlerNotThere", null, null), this.createHandlerExtension("handler2", "IAE", null, null, null)});
        List<IExceptionHandler> orderedHandlers = this.getOrderedHandlers();
        Assert.assertEquals((String)"handler1", (String)orderedHandlers.get(0).toString());
        Assert.assertEquals((String)"handler2", (String)orderedHandlers.get(1).toString());
        Exception exception = new Exception("no responsibility");
        this.manager.handleException((Throwable)exception);
        Assert.assertNull((String)"no one should handle", (Object)TestExceptionHandler.getHandledName());
    }

    public void testAddTwoHandlersWithNoParticularOrderAndExceptionNotHandled2() {
        this.manager.update(new IExceptionHandlerExtension[]{this.createHandlerExtension("handler2", "IAE", null, null, null), this.createHandlerExtension("handler1", "IAE", "handlerNotThere", null, null)});
        List<IExceptionHandler> orderedHandlers = this.getOrderedHandlers();
        Assert.assertEquals((String)"handler2", (String)orderedHandlers.get(0).toString());
        Assert.assertEquals((String)"handler1", (String)orderedHandlers.get(1).toString());
        Exception exception = new Exception("no responsibility");
        this.manager.handleException((Throwable)exception);
        Assert.assertNull((String)"no one should handle", (Object)TestExceptionHandler.getHandledName());
    }

    public void testAddThreeHandlersWithParticularOrderAndExceptionHandled1() {
        this.manager.update(new IExceptionHandlerExtension[]{this.createHandlerExtension("handler1", "IOE", "handlerNotThere", null, null), this.createHandlerExtension("handler2", "IOE", "*", null, null), this.createHandlerExtension("handler3", "IOE", null, null, "*")});
        List<IExceptionHandler> orderedHandlers = this.getOrderedHandlers();
        Assert.assertEquals((String)"handler2", (String)orderedHandlers.get(0).toString());
        Assert.assertEquals((String)"handler1", (String)orderedHandlers.get(1).toString());
        Assert.assertEquals((String)"handler3", (String)orderedHandlers.get(2).toString());
        Exception exception = new Exception("IOE");
        this.manager.handleException((Throwable)exception);
        Assert.assertEquals((String)"handler2", (String)TestExceptionHandler.getHandledName());
    }

    public void testAddThreeHandlersWithParticularOrderAndExceptionHandled2() {
        this.manager.update(new IExceptionHandlerExtension[]{this.createHandlerExtension("handler1", "IOE", "handlerNotThere", null, null), this.createHandlerExtension("handler3", "IOE", null, null, "*"), this.createHandlerExtension("handler2", "IAE", "*", null, null)});
        List<IExceptionHandler> orderedHandlers = this.getOrderedHandlers();
        Assert.assertEquals((String)"handler2", (String)orderedHandlers.get(0).toString());
        Assert.assertEquals((String)"handler1", (String)orderedHandlers.get(1).toString());
        Assert.assertEquals((String)"handler3", (String)orderedHandlers.get(2).toString());
        Exception exception = new Exception("IOE");
        this.manager.handleException((Throwable)exception);
        Assert.assertEquals((String)"handler1", (String)TestExceptionHandler.getHandledName());
    }

    public void testAddHandlersWithConflictingBeforeAndPostHandlerAttributes() {
        try {
            this.manager.update(new IExceptionHandlerExtension[]{this.createHandlerExtension("handler1", "IOE", "A", "B", null), this.createHandlerExtension("handler3", "IOE", null, null, "*"), this.createHandlerExtension("handler2", "IAE", "*", null, null)});
            SimpleExceptionHandlerManagerTest.fail((String)"Exception expected");
        }
        catch (InjectionFailure e) {
            Assert.assertTrue((boolean)e.getMessage().contains("uses both the deprecated 'before' and new 'getPostHandler' attributes"));
        }
    }

    public void stestFailingJob() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.manager.update(new IExceptionHandlerExtension[]{this.createLatchedHandlerExtension(latch)});
        this.manager.bind((IJobManager)Service.get(IJobManager.class));
        new Job("NPE"){

            protected IStatus run(IProgressMonitor monitor) {
                throw new NullPointerException("Ahh!");
            }
        }.schedule();
        latch.await();
        Assert.assertEquals(NullPointerException.class, TestLatchedExceptionHandler.caught.getClass());
    }

    public void testNoneFailingJob() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(0);
        this.manager.update(new IExceptionHandlerExtension[]{this.createLatchedHandlerExtension(latch)});
        this.manager.bind((IJobManager)Service.get(IJobManager.class));
        new Job("NPE"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        }.schedule();
        latch.await();
        Assert.assertNull((Object)TestLatchedExceptionHandler.caught);
    }

    private IExceptionHandlerExtension createHandlerExtension(final String name, final String exceptionMessageTrigger, final String before, final String postHandlers, final String preHandlers) {
        return new IExceptionHandlerExtension(){

            public IExceptionHandler createExceptionHandler() {
                return new TestExceptionHandler(name, exceptionMessageTrigger);
            }

            public String getBefore() {
                return before;
            }

            public String getExceptionHandler() {
                return name;
            }

            public String getName() {
                return name;
            }

            public String getPreHandlers() {
                return preHandlers;
            }

            public String getPostHandlers() {
                return postHandlers;
            }
        };
    }

    private List<IExceptionHandler> getOrderedHandlers() {
        return (List)ReflectionUtils.getHidden((Object)this.manager, (String)"handlers");
    }

    private IExceptionHandlerExtension createLatchedHandlerExtension(final CountDownLatch latch) {
        return new IExceptionHandlerExtension(){

            public IExceptionHandler createExceptionHandler() {
                return new TestLatchedExceptionHandler(latch);
            }

            public String getBefore() {
                return null;
            }

            public String getExceptionHandler() {
                return "Latcher";
            }

            public String getName() {
                return null;
            }

            public String getPreHandlers() {
                return null;
            }

            public String getPostHandlers() {
                return null;
            }
        };
    }

    private static class TestLatchedExceptionHandler
    implements IExceptionHandler {
        private final CountDownLatch latch;
        static Throwable caught;

        TestLatchedExceptionHandler(CountDownLatch latch) {
            this.latch = latch;
            caught = null;
        }

        public IExceptionHandler.Action handleException(Throwable t, String msg, Logger logger) {
            caught = t;
            this.latch.countDown();
            return IExceptionHandler.Action.OK;
        }
    }
}

