/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Arrays;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ArraysUtil;

@NonUITestCase
public class ArraysUtilTest
extends RienaTestCase {
    public void testCopy() {
        Object[] source = new String[]{"1", "2", "3", "4"};
        ArraysUtilTest.assertTrue((boolean)Arrays.equals(new String[0], ArraysUtil.copyRange((Object[])source, (int)0, (int)0)));
        ArraysUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"1"}, ArraysUtil.copyRange((Object[])source, (int)0, (int)1)));
        ArraysUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"1", "2"}, ArraysUtil.copyRange((Object[])source, (int)0, (int)2)));
        ArraysUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"2"}, ArraysUtil.copyRange((Object[])source, (int)1, (int)2)));
        ArraysUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"3", "4"}, ArraysUtil.copyRange((Object[])source, (int)2, (int)4)));
        ArraysUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"1", "2", "3", "4"}, ArraysUtil.copyRange((Object[])source, (int)0, (int)4)));
    }

    public void testCopyFailNullArray() {
        try {
            ArraysUtil.copyRange(null, (int)0, (int)2);
            ArraysUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testCopyFailNegativeSize() {
        try {
            Object[] source = new String[]{"1", "2", "3", "4"};
            ArraysUtil.copyRange((Object[])source, (int)0, (int)5);
            ArraysUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testCopyFailSizeTooBig() {
        try {
            ArraysUtil.copyRange(null, (int)2, (int)0);
            ArraysUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }
}

